/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.map.BiMap;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.util.HashMap;

public class AlgorithmUtil {
    private static final BiMap<String, String> map = new BiMap(new HashMap());

    public static String getAlgorithm(String idOrAlgorithm) {
        return (String)ObjectUtil.defaultIfNull((Object)AlgorithmUtil.getAlgorithmById(idOrAlgorithm), (Object)idOrAlgorithm);
    }

    public static String getId(String idOrAlgorithm) {
        return (String)ObjectUtil.defaultIfNull((Object)AlgorithmUtil.getIdByAlgorithm(idOrAlgorithm), (Object)idOrAlgorithm);
    }

    private static String getAlgorithmById(String id) {
        return (String)map.get((Object)id.toUpperCase());
    }

    private static String getIdByAlgorithm(String algorithm) {
        return (String)map.getInverse().get(algorithm);
    }

    static {
        map.put((Object)"HS256", (Object)HmacAlgorithm.HmacSHA256.getValue());
        map.put((Object)"HS384", (Object)HmacAlgorithm.HmacSHA384.getValue());
        map.put((Object)"HS512", (Object)HmacAlgorithm.HmacSHA512.getValue());
        map.put((Object)"RS256", (Object)SignAlgorithm.SHA256withRSA.getValue());
        map.put((Object)"RS384", (Object)SignAlgorithm.SHA384withRSA.getValue());
        map.put((Object)"RS512", (Object)SignAlgorithm.SHA512withRSA.getValue());
        map.put((Object)"ES256", (Object)SignAlgorithm.SHA256withECDSA.getValue());
        map.put((Object)"ES384", (Object)SignAlgorithm.SHA384withECDSA.getValue());
        map.put((Object)"ES512", (Object)SignAlgorithm.SHA512withECDSA.getValue());
        map.put((Object)"PS256", (Object)SignAlgorithm.SHA256withRSA_PSS.getValue());
        map.put((Object)"PS384", (Object)SignAlgorithm.SHA384withRSA_PSS.getValue());
        map.put((Object)"PS512", (Object)SignAlgorithm.SHA512withRSA_PSS.getValue());
    }
}

