/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricEncryptor {
    public byte[] encrypt(byte[] var1, KeyType var2);

    default public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset), keyType);
    }

    default public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset), keyType);
    }

    default public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.utf8Bytes((CharSequence)data), keyType);
    }

    default public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset, keyType));
    }

    default public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, charset, keyType));
    }

    default public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    default public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    @Deprecated
    default public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    default public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset, keyType));
    }
}

