/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.model.grok;

import cn.hutool.ai.core.AIConfig;
import cn.hutool.ai.core.BaseAIService;
import cn.hutool.ai.core.Message;
import cn.hutool.ai.model.grok.GrokService;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GrokServiceImpl
extends BaseAIService
implements GrokService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String MESSAGES = "/messages";
    private final String MODELS_ENDPOINT = "/models";
    private final String LANGUAGE_MODELS = "/language-models";
    private final String TOKENIZE_TEXT = "/tokenize-text";
    private final String DEFERRED_COMPLETION = "/chat/deferred-completion";

    public GrokServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(String prompt) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        return this.chat(messages);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        HttpResponse response = this.sendPost("/chat/completions", paramJson);
        return response.body();
    }

    @Override
    public String message(String prompt, int maxToken) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        String paramJson = this.buildMessageRequestBody(messages, maxToken);
        HttpResponse response = this.sendPost("/messages", paramJson);
        return response.body();
    }

    @Override
    public String chatVision(String prompt, List<String> images, String detail) {
        String paramJson = this.buildChatVisionRequestBody(prompt, images, detail);
        HttpResponse response = this.sendPost("/chat/completions", paramJson);
        return response.body();
    }

    @Override
    public String models() {
        HttpResponse response = this.sendGet("/models");
        return response.body();
    }

    @Override
    public String getModel(String modelId) {
        HttpResponse response = this.sendGet("/models/" + modelId);
        return response.body();
    }

    @Override
    public String languageModels() {
        HttpResponse response = this.sendGet("/language-models");
        return response.body();
    }

    @Override
    public String getLanguageModel(String modelId) {
        HttpResponse response = this.sendGet("/language-models/" + modelId);
        return response.body();
    }

    @Override
    public String tokenizeText(String text) {
        String paramJson = this.buildTokenizeRequestBody(text);
        HttpResponse response = this.sendPost("/tokenize-text", paramJson);
        return response.body();
    }

    @Override
    public String deferredCompletion(String requestId) {
        HttpResponse response = this.sendGet("/chat/deferred-completion/" + requestId);
        return response.body();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildChatVisionRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildMessageRequestBody(List<Message> messages, int maxToken) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.put("max_tokens", maxToken);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildTokenizeRequestBody(String text) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("text", text);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }
}

