/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.comparator.ComparableComparator;
import cn.hutool.core.comparator.PinyinComparator;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;

public class CompareUtil {
    public static <E extends Comparable<? super E>> Comparator<E> naturalComparator() {
        return ComparableComparator.INSTANCE;
    }

    public static <T> int compare(T c1, T c2, Comparator<T> comparator) {
        if (null == comparator) {
            return CompareUtil.compare((Comparable)c1, (Comparable)c2);
        }
        return comparator.compare(c1, c2);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return CompareUtil.compare(c1, c2, false);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean isNullGreater) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return isNullGreater ? 1 : -1;
        }
        if (c2 == null) {
            return isNullGreater ? -1 : 1;
        }
        return c1.compareTo(c2);
    }

    public static <T> int compare(T o1, T o2, boolean isNullGreater) {
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return isNullGreater ? -1 : 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Integer.compare(o1.hashCode(), o2.hashCode());
        if (0 == result) {
            result = CompareUtil.compare(o1.toString(), o2.toString());
        }
        return result;
    }

    public static <T> Comparator<T> comparingPinyin(Function<T, String> keyExtractor) {
        return CompareUtil.comparingPinyin(keyExtractor, false);
    }

    public static <T> Comparator<T> comparingPinyin(Function<T, String> keyExtractor, boolean reverse) {
        Objects.requireNonNull(keyExtractor);
        PinyinComparator pinyinComparator = new PinyinComparator();
        if (reverse) {
            return (o1, o2) -> pinyinComparator.compare((String)keyExtractor.apply(o2), (String)keyExtractor.apply(o1));
        }
        return (o1, o2) -> pinyinComparator.compare((String)keyExtractor.apply(o1), (String)keyExtractor.apply(o2));
    }
}

