/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean.copier.provider;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanValueProvider
implements ValueProvider<String> {
    private final Object source;
    private final boolean ignoreError;
    final Map<String, PropDesc> sourcePdMap;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this.source = bean;
        this.ignoreError = ignoreError;
        this.sourcePdMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
    }

    @Override
    public Object value(String key, Type valueType) {
        PropDesc sourcePd = this.getPropDesc(key, valueType);
        Object result = null;
        if (null != sourcePd) {
            result = sourcePd.getValue(this.source, valueType, this.ignoreError);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        PropDesc sourcePd = this.getPropDesc(key, null);
        return null != sourcePd && sourcePd.isReadable(false);
    }

    private PropDesc getPropDesc(String key, Type valueType) {
        PropDesc sourcePd = this.sourcePdMap.get(key);
        if (null == sourcePd && (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StrUtil.upperFirstAndAddPre(key, "is"));
        }
        return sourcePd;
    }
}

