/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.ObjectUtil;
import java.util.LinkedHashMap;
import java.util.List;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Comparable<Tree<T>> {
    private static final long serialVersionUID = 1L;
    private TreeNodeConfig treeNodeConfig;

    public Tree() {
        this((TreeNodeConfig)null);
    }

    public Tree(TreeNodeConfig treeNodeConfig) {
        this.treeNodeConfig = ObjectUtil.defaultIfNull(treeNodeConfig, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public T getId() {
        return (T)this.get(this.treeNodeConfig.getIdKey());
    }

    public Tree<T> setId(T id) {
        this.put(this.treeNodeConfig.getIdKey(), id);
        return this;
    }

    public T getParentId() {
        return (T)this.get(this.treeNodeConfig.getParentIdKey());
    }

    public Tree<T> setParentId(T parentId) {
        this.put(this.treeNodeConfig.getParentIdKey(), parentId);
        return this;
    }

    public T getName() {
        return (T)this.get(this.treeNodeConfig.getNameKey());
    }

    public Tree<T> setName(Object name) {
        this.put(this.treeNodeConfig.getNameKey(), name);
        return this;
    }

    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.treeNodeConfig.getWeightKey());
    }

    public Tree<T> setWeight(Comparable<?> weight) {
        this.put(this.treeNodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<Tree<T>> getChildren() {
        return (List)this.get(this.treeNodeConfig.getChildrenKey());
    }

    public void setChildren(List<Tree<T>> children) {
        this.put(this.treeNodeConfig.getChildrenKey(), children);
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }

    @Override
    public int compareTo(Tree<T> tree) {
        Comparable<?> weight = this.getWeight();
        if (null != weight) {
            Comparable<?> weightOther = tree.getWeight();
            return weight.compareTo(weightOther);
        }
        return 0;
    }
}

