/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlLog;
import cn.hutool.db.sql.SqlUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatementUtil {
    public static PreparedStatement fillParams(PreparedStatement ps, Collection<Object> params) throws SQLException {
        return StatementUtil.fillParams(ps, params.toArray(new Object[params.size()]));
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Object ... params) throws SQLException {
        if (ArrayUtil.isEmpty(params)) {
            return ps;
        }
        for (int i = 0; i < params.length; ++i) {
            int paramIndex = i + 1;
            Object param = params[i];
            if (null != param) {
                if (param instanceof java.util.Date) {
                    if (param instanceof Date) {
                        ps.setDate(paramIndex, (Date)param);
                        continue;
                    }
                    if (param instanceof Time) {
                        ps.setTime(paramIndex, (Time)param);
                        continue;
                    }
                    ps.setTimestamp(paramIndex, SqlUtil.toSqlTimestamp((java.util.Date)param));
                    continue;
                }
                if (param instanceof Number) {
                    if (param instanceof BigInteger) {
                        ps.setLong(paramIndex, ((BigInteger)param).longValue());
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        ps.setBigDecimal(paramIndex, (BigDecimal)param);
                        continue;
                    }
                    ps.setObject(paramIndex, param);
                    continue;
                }
                ps.setObject(paramIndex, param);
                continue;
            }
            ParameterMetaData pmd = ps.getParameterMetaData();
            int sqlType = 12;
            try {
                sqlType = pmd.getParameterType(paramIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ps.setNull(paramIndex, sqlType);
        }
        return ps;
    }

    public static PreparedStatement prepareStatement(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        return StatementUtil.prepareStatement(conn, sqlBuilder.build(), sqlBuilder.getParamValueArray());
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Collection<Object> params) throws SQLException {
        return StatementUtil.prepareStatement(conn, sql, params.toArray(new Object[params.size()]));
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTASNCE.log(sql, params);
        PreparedStatement ps = StrUtil.startWithIgnoreCase(sql, "insert") ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
        return StatementUtil.fillParams(ps, params);
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        return StatementUtil.prepareStatementForBatch(conn, sql, new ArrayIter<Object[]>(paramsBatch));
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTASNCE.log(sql, paramsBatch);
        PreparedStatement ps = conn.prepareStatement(sql);
        for (Object[] params : paramsBatch) {
            StatementUtil.fillParams(ps, params);
            ps.addBatch();
        }
        return ps;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTASNCE.log(sql, params);
        CallableStatement call = conn.prepareCall(sql);
        StatementUtil.fillParams((PreparedStatement)call, params);
        return call;
    }

    public static Long getGeneratedKeyOfLong(PreparedStatement ps) throws SQLException {
        Long l;
        ResultSet rs = null;
        try {
            rs = ps.getGeneratedKeys();
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            l = generatedKey;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return l;
    }

    public static List<Object> getGeneratedKeys(PreparedStatement ps) throws SQLException {
        ArrayList<Object> arrayList;
        ArrayList<Object> keys = new ArrayList<Object>();
        ResultSet rs = null;
        int i = 1;
        try {
            rs = ps.getGeneratedKeys();
            if (rs != null && rs.next()) {
                keys.add(rs.getObject(i++));
            }
            arrayList = keys;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return arrayList;
    }
}

