/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.io.IoUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Session;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.SqlRunner;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class DbUtil {
    private static final Log log = LogFactory.get();

    public static SqlConnRunner newSqlConnRunner(Dialect dialect) {
        return SqlConnRunner.create(dialect);
    }

    public static SqlConnRunner newSqlConnRunner(DataSource ds) {
        return SqlConnRunner.create(ds);
    }

    public static SqlConnRunner newSqlConnRunner(Connection conn) {
        return SqlConnRunner.create(DialectFactory.newDialect(conn));
    }

    public static SqlRunner newSqlRunner() {
        return SqlRunner.create(DbUtil.getDs());
    }

    public static SqlRunner newSqlRunner(DataSource ds) {
        return SqlRunner.create(ds);
    }

    public static SqlRunner newSqlRunner(DataSource ds, Dialect dialect) {
        return SqlRunner.create(ds, dialect);
    }

    public static Session newSession() {
        return Session.create(DbUtil.getDs());
    }

    public static Session newSession(DataSource ds) {
        return Session.create(ds);
    }

    public static Session newSession(Connection conn) {
        return Session.create(conn);
    }

    public static void close(Object ... objsToClose) {
        for (Object obj : objsToClose) {
            if (obj instanceof AutoCloseable) {
                IoUtil.close((AutoCloseable)obj);
                continue;
            }
            if (obj instanceof Closeable) {
                IoUtil.close((Closeable)obj);
                continue;
            }
            try {
                if (obj == null) continue;
                if (obj instanceof ResultSet) {
                    ((ResultSet)obj).close();
                    continue;
                }
                if (obj instanceof Statement) {
                    ((Statement)obj).close();
                    continue;
                }
                if (obj instanceof PreparedStatement) {
                    ((PreparedStatement)obj).close();
                    continue;
                }
                if (obj instanceof Connection) {
                    ((Connection)obj).close();
                    continue;
                }
                log.warn("Object {} not a ResultSet or Statement or PreparedStatement or Connection!", obj.getClass().getName());
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public static DataSource getDs() {
        return DSFactory.get();
    }

    public static DataSource getDs(String group) {
        return DSFactory.get(group);
    }

    public static DataSource getJndiDsWithLog(String jndiName) {
        try {
            return DbUtil.getJndiDs(jndiName);
        }
        catch (DbRuntimeException e) {
            log.error(e.getCause(), "Find JNDI datasource error!", new Object[0]);
            return null;
        }
    }

    public static DataSource getJndiDs(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static void setShowSqlGlobal(boolean isShowSql, boolean isFormatSql, boolean isShowParams) {
        SqlBuilder.setShowSql(isShowSql, isFormatSql, isShowParams);
    }
}

