/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.common.code;

import cn.enilu.common.code.ColumnDescriptor;
import cn.enilu.common.code.Loader;
import cn.enilu.common.code.TableDescriptor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.nutz.dao.Sqls;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.ioc.Ioc;

public class TableDescLoader
extends Loader {
    @Override
    public Map<String, TableDescriptor> loadTables(Ioc ioc, String basePackageName, String baseUri, String servPackageName, String modPackageName) throws SQLException {
        DataSource ds = (DataSource)ioc.get(DataSource.class);
        NutDao dao = new NutDao(ds);
        Sql sql = Sqls.create((String)"select database()");
        sql.setCallback(new SqlCallback(){

            public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        });
        dao.execute(sql);
        String database = sql.getString();
        Sql tableSchemaSql = Sqls.create((String)("select * from INFORMATION_SCHEMA.COLUMNS where TABLE_SCHEMA = '" + database + "'"));
        tableSchemaSql.setCallback(new SqlCallback(){

            public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                ArrayList result = new ArrayList();
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = metaData.getColumnName(i);
                        record.put(columnName, rs.getObject(columnName));
                    }
                    result.add(record);
                }
                return result;
            }
        });
        dao.execute(tableSchemaSql);
        List columns = tableSchemaSql.getList(Map.class);
        HashMap<String, TableDescriptor> tables = new HashMap<String, TableDescriptor>();
        for (Map columnInfo : columns) {
            String tableName = (String)columnInfo.get("TABLE_NAME");
            ColumnDescriptor column = new ColumnDescriptor();
            column.columnName = (String)columnInfo.get("COLUMN_NAME");
            if ("opAt".equals(column.columnName) || "opBy".equals(column.columnName) || "delFlag".equals(column.columnName)) continue;
            column.setDefaultValue(columnInfo.get("COLUMN_DEFAULT"));
            column.dataType = (String)columnInfo.get("DATA_TYPE");
            column.nullable = "YES".equals(columnInfo.get("IS_NULLABLE"));
            column.primary = "PRI".equals(columnInfo.get("COLUMN_KEY"));
            String columnType = (String)columnInfo.get("COLUMN_TYPE");
            column.setColumnType(columnType);
            column.setComment((String)columnInfo.get("COLUMN_COMMENT"));
            TableDescriptor table = (TableDescriptor)tables.get(tableName);
            if (table == null) {
                table = new TableDescriptor(tableName, null, basePackageName, baseUri, servPackageName, modPackageName);
                tables.put(tableName, table);
            }
            if (column.primary) {
                table.setPkType(column.getSimpleJavaTypeName());
            }
            table.addColumn(column);
        }
        Sql infomationSchemaSql = Sqls.create((String)("select * from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = '" + database + "'"));
        infomationSchemaSql.setCallback(new SqlCallback(){

            public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                ArrayList result = new ArrayList();
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = metaData.getColumnName(i);
                        record.put(columnName, rs.getObject(columnName));
                    }
                    result.add(record);
                }
                return result;
            }
        });
        dao.execute(infomationSchemaSql);
        List tableInfos = infomationSchemaSql.getList(Map.class);
        for (Map tableInfo : tableInfos) {
            String tableName = (String)tableInfo.get("TABLE_NAME");
            String comment = (String)tableInfo.get("TABLE_COMMENT");
            TableDescriptor table = (TableDescriptor)tables.get(tableName);
            if (table == null) continue;
            table.setComment(comment);
        }
        return tables;
    }
}

