/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.common.code;

import cn.enilu.common.code.EntityDescLoader;
import cn.enilu.common.code.Loader;
import cn.enilu.common.code.TableDescriptor;
import cn.enilu.common.code.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.impl.NutIoc;
import org.nutz.ioc.loader.json.JsonLoader;
import org.nutz.lang.Files;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;

public class Generator {
    private final Map<String, TableDescriptor> tables;
    private final TableDescriptor table;

    public Generator(Map<String, TableDescriptor> tables, TableDescriptor table) {
        this.tables = tables;
        this.table = table;
    }

    public void generate(String packageName, String templatePath, File file, boolean force) throws IOException {
        if (file.exists() && !force) {
            System.out.println("file " + file + " exists, skipped");
            return;
        }
        String code = this.generateCode(packageName, templatePath);
        file.getParentFile().mkdirs();
        Files.write((File)file, (Object)code.getBytes(Charset.forName("utf8")));
    }

    public String generateCode(String packageName, String templatePath) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)this.table);
        context.put("packageName", (Object)packageName);
        StringWriter writer = new StringWriter();
        String template = new String(Streams.readBytes((InputStream)ClassLoader.getSystemResourceAsStream(templatePath)), Charset.forName("utf8"));
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.references.strict", (Object)false);
        engine.init();
        engine.evaluate((Context)context, (Writer)writer, "generator", template);
        return writer.toString();
    }

    public static void main(String[] args) throws Exception {
        String configPath = "/code/code.json";
        Pattern includePattern = Pattern.compile(".*");
        Pattern excludePattern = null;
        String basePackageName = "cn.wizzer.modules";
        String controllerPackageName = "controllers";
        String servicePackageName = "services";
        String modelPackageName = "models";
        String outputDir = "src/main/java";
        boolean force = false;
        String baseUri = "/";
        String[] types = new String[]{"all"};
        String[] pages = new String[]{"index", "add", "edit", "detail"};
        Options options = new Options();
        options.addOption("c", "config", true, "spring datasource config file(classpath)");
        options.addOption("i", "include", true, "include table pattern");
        options.addOption("x", "exclude", true, "exclude table pattern");
        options.addOption("p", "package", true, "base package name,default:cn.wizzer.modules");
        options.addOption("ctr", "package", true, "controller base package name,default:controllers/${package}");
        options.addOption("mod", "package", true, "model base package name,default:models/${package}");
        options.addOption("sev", "package", true, "service base package name,default:services/${package}");
        options.addOption("v", "views", true, "for generator pages,default:all pages,eg: -v index_detail will generate index.html and detail.html");
        options.addOption("o", "output", true, "output directory, default is " + outputDir);
        options.addOption("u", "base-uri", true, "base uri prefix, default is /");
        options.addOption("f", "force", false, "force generate file even if file exists");
        options.addOption("h", "help", false, "show help message");
        GnuParser parser = new GnuParser();
        try {
            String[] extraArgs;
            CommandLine commandLine = parser.parse(options, args);
            if (commandLine.hasOption("c")) {
                configPath = commandLine.getOptionValue("c");
            }
            if (commandLine.hasOption("i")) {
                includePattern = Pattern.compile(commandLine.getOptionValue("i"), 2);
            }
            if (commandLine.hasOption("x")) {
                excludePattern = Pattern.compile(commandLine.getOptionValue("x"), 2);
            }
            if (commandLine.hasOption("p")) {
                basePackageName = commandLine.getOptionValue("p");
            }
            if (commandLine.hasOption("ctr")) {
                controllerPackageName = commandLine.getOptionValue("ctr");
            }
            if (commandLine.hasOption("sev")) {
                servicePackageName = commandLine.getOptionValue("sev");
            }
            if (commandLine.hasOption("mod")) {
                modelPackageName = commandLine.getOptionValue("mod");
            }
            if (commandLine.hasOption("o")) {
                outputDir = commandLine.getOptionValue("o");
            }
            if (commandLine.hasOption("u")) {
                baseUri = commandLine.getOptionValue("u");
            }
            if (commandLine.hasOption("v")) {
                String pagestr = commandLine.getOptionValue("v");
                pages = pagestr.split("_");
            }
            force = commandLine.hasOption("f");
            if (commandLine.hasOption("h")) {
                Generator.usage(options);
            }
            if ((extraArgs = commandLine.getArgs()).length > 0) {
                types = extraArgs;
            }
        }
        catch (Exception e) {
            Generator.usage(options);
        }
        NutIoc ioc = new NutIoc((IocLoader)new JsonLoader(new String[]{configPath}));
        Loader loader = (Loader)ioc.get(Loader.class, "loader");
        Map<String, TableDescriptor> tables = loader.loadTables((Ioc)ioc, basePackageName, baseUri, servicePackageName, modelPackageName);
        for (Map.Entry<String, TableDescriptor> entry : tables.entrySet()) {
            String tableName = entry.getKey();
            if (excludePattern != null && excludePattern.matcher(tableName).find()) {
                System.out.println("skip " + tableName);
                continue;
            }
            if (includePattern != null && !includePattern.matcher(tableName).find()) {
                System.out.println("skip " + tableName);
                continue;
            }
            TableDescriptor table = entry.getValue();
            System.out.println("generate " + tableName + " ...");
            Generator generator = new Generator(tables, table);
            HashMap<String, String> typeMap = new HashMap<String, String>();
            typeMap.put("model", modelPackageName);
            typeMap.put("service", servicePackageName);
            typeMap.put("controller", controllerPackageName);
            for (String type : new String[]{"model", "service", "controller", "view"}) {
                if (!Generator.isTypeMatch(types, type)) continue;
                if (type.equals("view")) {
                    Generator.generateViews(force, table, generator, pages);
                    continue;
                }
                if (loader instanceof EntityDescLoader && type.equals("model")) continue;
                String packageName = basePackageName + "." + (String)typeMap.get(type);
                String templatePath = "code/" + type + ".vm";
                String packagePath = packageName.replace('.', '/');
                String className = table.getEntityClassName();
                if (!"model".equals(type)) {
                    className = Utils.UPPER_CAMEL(className) + Strings.upperFirst((CharSequence)type);
                }
                File file = new File(outputDir, packagePath + "/" + className + ".java");
                System.out.println("generate " + file.getName());
                generator.generate(packageName, templatePath, file, force);
            }
        }
        System.out.println("done!");
    }

    private static boolean isTypeMatch(String[] types, String type) {
        for (String t : types) {
            if (!t.equalsIgnoreCase(type) && !"all".equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    private static void generateViews(boolean force, TableDescriptor table, Generator generator, String[] pages) throws IOException {
        for (String view : pages) {
            String templatePath = "code/view/" + view + ".html.vm";
            File file = new File("src/main/webapp/WEB-INF/views/" + table.getViewBasePath() + "/" + view + ".html");
            System.out.println("generate html:" + file.getName());
            generator.generate(null, templatePath, file, force);
        }
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Main [options] [all|entity|service|controller|view]", options);
        System.exit(1);
    }
}

