/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.common.code;

import cn.enilu.common.code.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Strings;

public class ColumnDescriptor {
    private static Map<String, Class<?>> typeMapping = new HashMap();
    private static Map<String, String> labelMapping;
    private static Pattern COLUMN_TYPE_PATTERN;
    private static Pattern ENUM_PATTERN;
    public String columnName;
    private String label;
    public boolean primary;
    public String dataType;
    public String columnType;
    public int size;
    public boolean nullable;
    private Object defaultValue;
    private String comment;
    private String fieldName;
    private List<String> enumValues = new ArrayList<String>();
    private List<Validation> validations = new ArrayList<Validation>();
    private boolean validationBuilt = false;
    private String queryOperator;

    private boolean containsValidation(Class<?> klass) {
        for (Validation v : this.validations) {
            if (v.klass != klass) continue;
            return true;
        }
        return false;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        String defaultLabel = labelMapping.get(this.columnName);
        if (defaultLabel != null) {
            return defaultLabel;
        }
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (comment == null) {
            return;
        }
        this.extractLabel(comment);
        this.extractSearchable(comment);
    }

    private void extractLabel(String comment) {
        Pattern labelPattern = Pattern.compile("label:\\s*([^,;\uff0c]+)");
        Matcher m = labelPattern.matcher(comment);
        if (m.find()) {
            this.label = m.group(1);
        }
    }

    public String getQueryOperator() {
        return this.queryOperator;
    }

    private void extractSearchable(String comment) {
        Pattern queryPattern = Pattern.compile("searchable:\\s*(\\w+)");
        Matcher m = queryPattern.matcher(comment);
        if (m.find()) {
            this.queryOperator = m.group(1);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFieldName() {
        if (Strings.isBlank((CharSequence)this.fieldName)) {
            return Utils.LOWER_CAMEL(this.columnName);
        }
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public void setColumnType(String columnType) {
        Matcher m = ENUM_PATTERN.matcher(columnType);
        if (m.find()) {
            this.columnType = "enum";
            String s = m.group(1);
            for (String v : s.split(",")) {
                v = v.trim().replaceAll("'", "");
                this.enumValues.add(v);
            }
            return;
        }
        m = COLUMN_TYPE_PATTERN.matcher(columnType);
        if (m.find()) {
            if (m.group(2) != null) {
                this.size = Integer.parseInt(m.group(2));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.columnType = m.group(1);
    }

    public String getJavaType() {
        if ("tinyint".equalsIgnoreCase(this.dataType) && this.size == 1) {
            return Boolean.TYPE.getName();
        }
        if ("enum".equalsIgnoreCase(this.dataType)) {
            return this.getUpperJavaFieldName();
        }
        Class<?> type = typeMapping.get(this.dataType);
        if (type != null) {
            return type.getName();
        }
        return String.class.getName();
    }

    public String getSimpleJavaTypeName() {
        return this.getJavaType().replaceFirst("^.*\\.", "");
    }

    public boolean isEnum() {
        return "enum".equalsIgnoreCase(this.dataType);
    }

    public boolean isBoolean() {
        return Boolean.TYPE.getName().equals(this.getJavaType());
    }

    public boolean isTimestamp() {
        return "timestamp".equalsIgnoreCase(this.dataType);
    }

    public String getUpperJavaFieldName() {
        return Utils.LOWER_CAMEL(this.columnName);
    }

    public String getGetterMethodName() {
        if (this.isBoolean()) {
            return "is" + this.getUpperJavaFieldName();
        }
        return "get" + this.getUpperJavaFieldName();
    }

    public String getSetterMethodName() {
        return "set" + this.getUpperJavaFieldName();
    }

    public String getColumnAnnotation() {
        if (this.primary) {
            return "@Name\r\n\t@Prev(els = {@EL(\"uuid()\")})";
        }
        return "@Column";
    }

    public void setDefaultValue(Object v) {
        this.defaultValue = v;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueCode() {
        if (this.isEnum()) {
            return this.getSimpleJavaTypeName() + "." + this.defaultValue;
        }
        if (this.isBoolean()) {
            if ("1".equals(this.defaultValue.toString())) {
                return "true";
            }
            return "false";
        }
        if (this.isTimestamp() && ("0000-00-00 00:00:00".equals(this.defaultValue) || "CURRENT_TIMESTAMP".equals(this.defaultValue))) {
            return "DateTime.now()";
        }
        if (this.defaultValue != null && Long.class.getName().equals(this.getJavaType())) {
            return this.defaultValue + "L";
        }
        if (this.defaultValue != null && BigDecimal.class.getName().equals(this.getJavaType())) {
            return "new BigDecimal(\"" + this.defaultValue.toString() + "\")";
        }
        return "\"" + this.getDefaultValue().toString() + "\"";
    }

    public String getValidationFormClass() {
        return "";
    }

    static {
        typeMapping.put("varchar", String.class);
        typeMapping.put("enum", String.class);
        typeMapping.put("bigint", Long.class);
        typeMapping.put("long", Long.class);
        typeMapping.put("integer", Integer.class);
        typeMapping.put("float", Float.class);
        typeMapping.put("double", Double.class);
        typeMapping.put("int", Integer.class);
        typeMapping.put("timestamp", Integer.class);
        typeMapping.put("datetime", Integer.class);
        typeMapping.put("boolean", Boolean.TYPE);
        typeMapping.put("tinyint", Boolean.TYPE);
        typeMapping.put("bool", Boolean.TYPE);
        typeMapping.put("decimal", BigDecimal.class);
        labelMapping = new HashMap<String, String>();
        labelMapping.put("id", "ID");
        labelMapping.put("opAt", "\u64cd\u4f5c\u65f6\u95f4");
        labelMapping.put("opBy", "\u64cd\u4f5c\u4eba");
        labelMapping.put("delFlag", "\u5220\u9664\u6807\u8bb0");
        COLUMN_TYPE_PATTERN = Pattern.compile("^(\\w+)(?:\\((\\d+)\\))?");
        ENUM_PATTERN = Pattern.compile("enum\\((.+)\\)");
    }

    public static class Validation {
        public final Class<?> klass;
        private final String annotation;

        public Validation(Class<?> klass, String annotation) {
            this.klass = klass;
            this.annotation = annotation;
        }

        public String getAnnotation() {
            return this.annotation;
        }
    }
}

