/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.conditions;

import cn.easyes.common.constants.BaseEsConstants;
import cn.easyes.common.enums.AggregationTypeEnum;
import cn.easyes.common.enums.BaseEsParamTypeEnum;
import cn.easyes.common.enums.EsAttachTypeEnum;
import cn.easyes.common.utils.ArrayUtils;
import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.MyOptional;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.AggregationParam;
import cn.easyes.core.biz.BaseEsParam;
import cn.easyes.core.biz.BaseSortParam;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.biz.GeoParam;
import cn.easyes.core.biz.HighLightParam;
import cn.easyes.core.biz.OrCount;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.conditions.LambdaEsQueryWrapper;
import cn.easyes.core.config.GlobalConfig;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.core.toolkit.EsQueryTypeUtil;
import cn.easyes.core.toolkit.FieldUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class WrapperProcessor {
    public static SearchSourceBuilder buildSearchSourceBuilder(LambdaEsQueryWrapper<?> wrapper, Class<?> entityClass) {
        BoolQueryBuilder boolQueryBuilder = WrapperProcessor.initBoolQueryBuilder(wrapper.baseEsParamList, wrapper.enableMust2Filter, entityClass);
        Optional.ofNullable(wrapper.matchAllQuery).ifPresent(p -> boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchAllQuery()));
        SearchSourceBuilder searchSourceBuilder = WrapperProcessor.initSearchSourceBuilder(wrapper, entityClass);
        Optional.ofNullable(wrapper.geoParam).ifPresent(geoParam -> WrapperProcessor.setGeoQuery(geoParam, boolQueryBuilder, entityClass));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        return searchSourceBuilder;
    }

    public static BoolQueryBuilder initBoolQueryBuilder(List<BaseEsParam> baseEsParamList, Boolean enableMust2Filter, Class<?> entityClass) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        OrCount orCount = WrapperProcessor.getOrCount(baseEsParamList);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder inner = null;
        int start = 0;
        int end = 0;
        int remainSetUp = orCount.getOrInnerCount();
        boolean hasSetUp = false;
        for (int i = 0; i < baseEsParamList.size(); ++i) {
            boolean hasLogicOperator;
            BaseEsParam baseEsParam = baseEsParamList.get(i);
            if (orCount.getOrAllCount() > orCount.getOrInnerCount()) {
                BaseEsParam.setUp(baseEsParam);
            } else if (!hasSetUp) {
                for (int j = i; j < baseEsParamList.size(); ++j) {
                    BaseEsParam andOr = baseEsParamList.get(j);
                    if (BaseEsParamTypeEnum.AND_LEFT_BRACKET.getType().equals(andOr.getType()) || BaseEsParamTypeEnum.OR_LEFT_BRACKET.getType().equals(andOr.getType())) {
                        start = j;
                    }
                    if (BaseEsParamTypeEnum.AND_RIGHT_BRACKET.getType().equals(andOr.getType()) || BaseEsParamTypeEnum.OR_RIGHT_BRACKET.getType().equals(andOr.getType())) {
                        end = j;
                    }
                    if (remainSetUp <= 0 || end <= start) continue;
                    --remainSetUp;
                    for (int k = start; k < end; ++k) {
                        BaseEsParam.setUp(baseEsParamList.get(k));
                        hasSetUp = true;
                    }
                }
            }
            boolean bl = hasLogicOperator = BaseEsParamTypeEnum.AND_LEFT_BRACKET.getType().equals(baseEsParam.getType()) || BaseEsParamTypeEnum.OR_LEFT_BRACKET.getType().equals(baseEsParam.getType());
            if (hasLogicOperator) {
                inner = QueryBuilders.boolQuery();
            }
            if (Objects.equals(BaseEsParamTypeEnum.AND_RIGHT_BRACKET.getType(), baseEsParam.getType())) {
                boolQueryBuilder.must((QueryBuilder)inner);
                inner = null;
            }
            if (Objects.equals(BaseEsParamTypeEnum.OR_RIGHT_BRACKET.getType(), baseEsParam.getType())) {
                boolQueryBuilder.should((QueryBuilder)inner);
                inner = null;
            }
            Optional.ofNullable(enableMust2Filter).ifPresent(baseEsParam::setEnableMust2Filter);
            if (Objects.isNull(inner)) {
                WrapperProcessor.addQuery(baseEsParam, boolQueryBuilder, entityInfo, dbConfig);
                continue;
            }
            WrapperProcessor.addQuery(baseEsParam, inner, entityInfo, dbConfig);
        }
        return boolQueryBuilder;
    }

    private static OrCount getOrCount(List<BaseEsParam> baseEsParamList) {
        OrCount orCount = new OrCount();
        int end = 0;
        int orAllCount = 0;
        int orInnerCount = 0;
        block0: for (int i = 0; i < baseEsParamList.size(); ++i) {
            boolean hasLogicOperator;
            BaseEsParam baseEsParam = baseEsParamList.get(i);
            if (BaseEsParamTypeEnum.OR_ALL.getType().equals(baseEsParam.getType())) {
                ++orAllCount;
            }
            boolean bl = hasLogicOperator = BaseEsParamTypeEnum.AND_LEFT_BRACKET.getType().equals(baseEsParam.getType()) || BaseEsParamTypeEnum.OR_LEFT_BRACKET.getType().equals(baseEsParam.getType());
            if (!hasLogicOperator) continue;
            int start = i;
            for (int j = i; j < baseEsParamList.size(); ++j) {
                BaseEsParam andOr = baseEsParamList.get(j);
                if (BaseEsParamTypeEnum.AND_RIGHT_BRACKET.getType().equals(andOr.getType()) || BaseEsParamTypeEnum.OR_RIGHT_BRACKET.getType().equals(andOr.getType())) {
                    end = j;
                }
                if (start >= end) continue;
                for (int k = start; k < end; ++k) {
                    if (!BaseEsParamTypeEnum.OR_ALL.getType().equals(baseEsParamList.get(k).getType())) continue;
                    ++orInnerCount;
                }
                continue block0;
            }
        }
        orCount.setOrAllCount(orAllCount);
        orCount.setOrInnerCount(orInnerCount);
        return orCount;
    }

    private static SearchSourceBuilder initSearchSourceBuilder(LambdaEsQueryWrapper<?> wrapper, Class<?> entityClass) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        Map<String, String> mappingColumnMap = entityInfo.getMappingColumnMap();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        WrapperProcessor.setHighLight(entityInfo.getHighLightParams(), searchSourceBuilder);
        WrapperProcessor.setSort(wrapper, mappingColumnMap, searchSourceBuilder);
        WrapperProcessor.setFetchSource(wrapper, mappingColumnMap, searchSourceBuilder);
        WrapperProcessor.setAggregations(wrapper, mappingColumnMap, searchSourceBuilder);
        Optional.ofNullable(wrapper.from).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).from(arg_0));
        MyOptional.ofNullable((Object)wrapper.size).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).size(arg_0), (Object)BaseEsConstants.DEFAULT_SIZE);
        if (searchSourceBuilder.size() > BaseEsConstants.DEFAULT_SIZE) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHits(GlobalConfigCache.getGlobalConfig().getDbConfig().isEnableTrackTotalHits());
        }
        return searchSourceBuilder;
    }

    private static GeoBoundingBoxQueryBuilder initGeoBoundingBoxQueryBuilder(GeoParam geoParam) {
        boolean invalidParam;
        boolean bl = invalidParam = Objects.isNull(geoParam) || Objects.isNull(geoParam.getTopLeft()) || Objects.isNull(geoParam.getBottomRight());
        if (invalidParam) {
            return null;
        }
        GeoBoundingBoxQueryBuilder builder = QueryBuilders.geoBoundingBoxQuery((String)geoParam.getField());
        Optional.ofNullable(geoParam.getBoost()).ifPresent(arg_0 -> ((GeoBoundingBoxQueryBuilder)builder).boost(arg_0));
        builder.setCorners(geoParam.getTopLeft(), geoParam.getBottomRight());
        return builder;
    }

    private static GeoDistanceQueryBuilder initGeoDistanceQueryBuilder(GeoParam geoParam) {
        boolean invalidParam;
        boolean bl = invalidParam = Objects.isNull(geoParam) || Objects.isNull(geoParam.getDistanceStr()) && Objects.isNull(geoParam.getDistance());
        if (invalidParam) {
            return null;
        }
        GeoDistanceQueryBuilder builder = QueryBuilders.geoDistanceQuery((String)geoParam.getField());
        Optional.ofNullable(geoParam.getBoost()).ifPresent(arg_0 -> ((GeoDistanceQueryBuilder)builder).boost(arg_0));
        Optional.ofNullable(geoParam.getDistanceStr()).ifPresent(arg_0 -> ((GeoDistanceQueryBuilder)builder).distance(arg_0));
        Optional.ofNullable(geoParam.getDistance()).ifPresent(distance -> builder.distance(distance.doubleValue(), geoParam.getDistanceUnit()));
        Optional.ofNullable(geoParam.getCentralGeoPoint()).ifPresent(arg_0 -> ((GeoDistanceQueryBuilder)builder).point(arg_0));
        return builder;
    }

    private static GeoPolygonQueryBuilder initGeoPolygonQueryBuilder(GeoParam geoParam) {
        boolean invalidParam;
        boolean bl = invalidParam = Objects.isNull(geoParam) || CollectionUtils.isEmpty(geoParam.getGeoPoints());
        if (invalidParam) {
            return null;
        }
        GeoPolygonQueryBuilder builder = QueryBuilders.geoPolygonQuery((String)geoParam.getField(), geoParam.getGeoPoints());
        Optional.ofNullable(geoParam.getBoost()).ifPresent(arg_0 -> ((GeoPolygonQueryBuilder)builder).boost(arg_0));
        return builder;
    }

    private static GeoShapeQueryBuilder initGeoShapeQueryBuilder(GeoParam geoParam) {
        boolean invalidParam;
        boolean bl = invalidParam = Objects.isNull(geoParam) || Objects.isNull(geoParam.getIndexedShapeId()) && Objects.isNull(geoParam.getGeometry());
        if (invalidParam) {
            return null;
        }
        GeoShapeQueryBuilder builder = StringUtils.isNotBlank((CharSequence)geoParam.getIndexedShapeId()) ? QueryBuilders.geoShapeQuery((String)geoParam.getField(), (String)geoParam.getIndexedShapeId()) : QueryBuilders.geoShapeQuery((String)geoParam.getField(), (Geometry)geoParam.getGeometry());
        Optional.ofNullable(geoParam.getShapeRelation()).ifPresent(arg_0 -> ((GeoShapeQueryBuilder)builder).relation(arg_0));
        Optional.ofNullable(geoParam.getBoost()).ifPresent(arg_0 -> ((GeoShapeQueryBuilder)builder).boost(arg_0));
        return builder;
    }

    public static void setGeoQuery(GeoParam geoParam, BoolQueryBuilder boolQueryBuilder, Class<?> entityClass) {
        Map<String, String> mappingColumnMap = EntityInfoHelper.getEntityInfo(entityClass).getMappingColumnMap();
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        String realField = FieldUtils.getRealField(geoParam.getField(), mappingColumnMap, dbConfig);
        geoParam.setField(realField);
        GeoBoundingBoxQueryBuilder geoBoundingBox = WrapperProcessor.initGeoBoundingBoxQueryBuilder(geoParam);
        WrapperProcessor.doGeoSet(geoParam.isIn(), (QueryBuilder)geoBoundingBox, boolQueryBuilder, dbConfig);
        GeoDistanceQueryBuilder geoDistance = WrapperProcessor.initGeoDistanceQueryBuilder(geoParam);
        WrapperProcessor.doGeoSet(geoParam.isIn(), (QueryBuilder)geoDistance, boolQueryBuilder, dbConfig);
        GeoPolygonQueryBuilder geoPolygon = WrapperProcessor.initGeoPolygonQueryBuilder(geoParam);
        WrapperProcessor.doGeoSet(geoParam.isIn(), (QueryBuilder)geoPolygon, boolQueryBuilder, dbConfig);
        GeoShapeQueryBuilder geoShape = WrapperProcessor.initGeoShapeQueryBuilder(geoParam);
        WrapperProcessor.doGeoSet(geoParam.isIn(), (QueryBuilder)geoShape, boolQueryBuilder, dbConfig);
    }

    private static void doGeoSet(Boolean isIn, QueryBuilder queryBuilder, BoolQueryBuilder boolQueryBuilder, GlobalConfig.DbConfig dbConfig) {
        Optional.ofNullable(queryBuilder).ifPresent(present -> {
            if (isIn.booleanValue()) {
                if (dbConfig.isEnableMust2Filter()) {
                    boolQueryBuilder.filter(present);
                } else {
                    boolQueryBuilder.must(present);
                }
            } else {
                boolQueryBuilder.mustNot(present);
            }
        });
    }

    private static void addQuery(BaseEsParam baseEsParam, BoolQueryBuilder boolQueryBuilder, EntityInfo entityInfo, GlobalConfig.DbConfig dbConfig) {
        boolean enableMust2Filter = Objects.isNull(baseEsParam.getEnableMust2Filter()) ? dbConfig.isEnableMust2Filter() : baseEsParam.getEnableMust2Filter().booleanValue();
        baseEsParam.getMustList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.MUST.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getMustMultiFieldList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, fieldValueModel.getEsQueryType(), EsAttachTypeEnum.MUST.getType(), fieldValueModel.getOriginalAttachType(), enableMust2Filter, FieldUtils.getRealFields(fieldValueModel.getFields(), entityInfo.getMappingColumnMap()), fieldValueModel.getValue(), fieldValueModel.getExt(), fieldValueModel.getMinimumShouldMatch(), fieldValueModel.getBoost()));
        baseEsParam.getFilterList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.FILTER.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getShouldList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.SHOULD.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getShouldMultiFieldList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, fieldValueModel.getEsQueryType(), EsAttachTypeEnum.SHOULD.getType(), fieldValueModel.getOriginalAttachType(), enableMust2Filter, FieldUtils.getRealFields(fieldValueModel.getFields(), entityInfo.getMappingColumnMap()), fieldValueModel.getValue(), fieldValueModel.getExt(), fieldValueModel.getMinimumShouldMatch(), fieldValueModel.getBoost()));
        baseEsParam.getMustNotList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.MUST_NOT.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getGtList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.GT.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getLtList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.LT.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getGeList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.GE.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getLeList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.LE.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getBetweenList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.BETWEEN.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getNotBetweenList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.NOT_BETWEEN.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getInList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.IN.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getNotInList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.NOT_IN.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getIsNullList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.NOT_EXISTS.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getNotNullList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.EXISTS.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getLikeLeftList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.LIKE_LEFT.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
        baseEsParam.getLikeRightList().forEach(fieldValueModel -> EsQueryTypeUtil.addQueryByType(boolQueryBuilder, EsAttachTypeEnum.LIKE_RIGHT.getType(), enableMust2Filter, fieldValueModel, entityInfo, dbConfig));
    }

    public static boolean includeId(String idField, LambdaEsQueryWrapper<?> wrapper) {
        if (ArrayUtils.isEmpty((Object[])wrapper.include) && ArrayUtils.isEmpty((Object[])wrapper.exclude)) {
            return true;
        }
        if (ArrayUtils.isNotEmpty((Object[])wrapper.include) && Arrays.asList(wrapper.include).contains(idField)) {
            return true;
        }
        return ArrayUtils.isNotEmpty((Object[])wrapper.exclude) && !Arrays.asList(wrapper.exclude).contains(idField);
    }

    private static void setFetchSource(LambdaEsQueryWrapper<?> wrapper, Map<String, String> mappingColumnMap, SearchSourceBuilder searchSourceBuilder) {
        if (ArrayUtils.isEmpty((Object[])wrapper.include) && ArrayUtils.isEmpty((Object[])wrapper.exclude)) {
            return;
        }
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        String[] includes = FieldUtils.getRealFields(wrapper.include, mappingColumnMap, dbConfig);
        String[] excludes = FieldUtils.getRealFields(wrapper.exclude, mappingColumnMap, dbConfig);
        searchSourceBuilder.fetchSource(includes, excludes);
    }

    private static void setHighLight(List<HighLightParam> highLightParams, SearchSourceBuilder searchSourceBuilder) {
        if (CollectionUtils.isEmpty(highLightParams)) {
            return;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highLightParams.forEach(highLightParam -> {
            if (StringUtils.isNotBlank((CharSequence)highLightParam.getHighLightField())) {
                HighlightBuilder.Field field = new HighlightBuilder.Field(highLightParam.getHighLightField());
                field.highlighterType(highLightParam.getHighLightType().getValue());
                highlightBuilder.field(field);
                highlightBuilder.fragmentSize(Integer.valueOf(highLightParam.getFragmentSize()));
                highlightBuilder.preTags(new String[]{highLightParam.getPreTag()});
                highlightBuilder.postTags(new String[]{highLightParam.getPostTag()});
            }
        });
        searchSourceBuilder.highlighter(highlightBuilder);
    }

    private static void initHighlightBuilder(HighlightBuilder highlightBuilder, List<HighLightParam> highLightParamList) {
        if (!CollectionUtils.isEmpty(highLightParamList)) {
            highLightParamList.forEach(highLightParam -> {
                if (StringUtils.isNotBlank((CharSequence)highLightParam.getHighLightField())) {
                    HighlightBuilder.Field field = new HighlightBuilder.Field(highLightParam.getHighLightField());
                    field.highlighterType(highLightParam.getHighLightType().getValue());
                    highlightBuilder.field(field);
                    highlightBuilder.field(highLightParam.getHighLightField());
                    highlightBuilder.preTags(new String[]{highLightParam.getPreTag()});
                    highlightBuilder.postTags(new String[]{highLightParam.getPostTag()});
                }
            });
        }
    }

    private static void setSort(LambdaEsQueryWrapper<?> wrapper, Map<String, String> mappingColumnMap, SearchSourceBuilder searchSourceBuilder) {
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        if (CollectionUtils.isNotEmpty((Collection)wrapper.baseSortParams)) {
            wrapper.baseSortParams.forEach(baseSortParam -> {
                String realField = Objects.isNull(baseSortParam.getSortField()) ? null : FieldUtils.getRealField(baseSortParam.getSortField(), mappingColumnMap, dbConfig);
                SortBuilder<?> sortBuilder = WrapperProcessor.getSortBuilder(realField, baseSortParam);
                Optional.ofNullable(sortBuilder).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)wrapper.orderByParams)) {
            wrapper.orderByParams.forEach(orderByParam -> {
                FieldSortBuilder fieldSortBuilder = new FieldSortBuilder(orderByParam.getOrder());
                if (SortOrder.ASC.toString().equalsIgnoreCase(orderByParam.getSort())) {
                    fieldSortBuilder.order(SortOrder.ASC);
                }
                if (SortOrder.DESC.toString().equalsIgnoreCase(orderByParam.getSort())) {
                    fieldSortBuilder.order(SortOrder.DESC);
                }
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            });
        }
    }

    private static SortBuilder<?> getSortBuilder(String realField, BaseSortParam baseSortParam) {
        switch (baseSortParam.getOrderTypeEnum()) {
            case FIELD: {
                return SortBuilders.fieldSort((String)realField).order(baseSortParam.getSortOrder());
            }
            case SCORE: {
                return SortBuilders.scoreSort().order(baseSortParam.getSortOrder());
            }
            case GEO: {
                return ((GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)realField, (GeoPoint[])baseSortParam.getGeoPoints()).order(baseSortParam.getSortOrder())).geoDistance(baseSortParam.getGeoDistance()).unit(baseSortParam.getUnit());
            }
            case CUSTOMIZE: {
                return baseSortParam.getSortBuilder();
            }
        }
        return null;
    }

    private static void setAggregations(LambdaEsQueryWrapper<?> wrapper, Map<String, String> mappingColumnMap, SearchSourceBuilder searchSourceBuilder) {
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        Optional.ofNullable(wrapper.distinctField).ifPresent(distinctField -> {
            String realField = FieldUtils.getRealField(distinctField, mappingColumnMap, dbConfig);
            searchSourceBuilder.collapse(new CollapseBuilder(realField));
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"repeat_num").field(realField));
        });
        List aggregationParamList = wrapper.aggregationParamList;
        if (CollectionUtils.isEmpty((Collection)aggregationParamList)) {
            return;
        }
        AggregationBuilder root = null;
        AggregationBuilder cursor = null;
        for (AggregationParam aggParam : aggregationParamList) {
            String realField = FieldUtils.getRealField(aggParam.getField(), mappingColumnMap, dbConfig);
            AggregationBuilder builder = WrapperProcessor.getRealAggregationBuilder(aggParam.getAggregationType(), aggParam.getName(), realField);
            if (aggParam.isEnablePipeline()) {
                if (root == null) {
                    cursor = root = builder;
                    continue;
                }
                cursor.subAggregation(builder);
                if (!(builder instanceof TermsAggregationBuilder)) continue;
                cursor = builder;
                continue;
            }
            searchSourceBuilder.aggregation(builder);
        }
        Optional.ofNullable(root).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
    }

    private static AggregationBuilder getRealAggregationBuilder(AggregationTypeEnum aggType, String name, String realField) {
        ValuesSourceAggregationBuilder aggregationBuilder;
        name = name + aggType.getValue();
        switch (aggType) {
            case AVG: {
                aggregationBuilder = AggregationBuilders.avg((String)name).field(realField);
                break;
            }
            case MIN: {
                aggregationBuilder = AggregationBuilders.min((String)name).field(realField);
                break;
            }
            case MAX: {
                aggregationBuilder = AggregationBuilders.max((String)name).field(realField);
                break;
            }
            case SUM: {
                aggregationBuilder = AggregationBuilders.sum((String)name).field(realField);
                break;
            }
            case TERMS: {
                aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)name).field(realField)).size(Integer.MAX_VALUE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u805a\u5408\u7c7b\u578b,\u53c2\u89c1AggregationTypeEnum");
            }
        }
        return aggregationBuilder;
    }
}

