/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.common.utils;

import cn.easyes.common.utils.LogUtils;
import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class EEVersionUtils {
    public static <T> String getJarVersion(Class<T> objectClass) {
        return Optional.ofNullable(objectClass.getPackage().getImplementationVersion()).orElse("unknown");
    }

    public static String getClientVersion(RestHighLevelClient restHighLevelClient) {
        try {
            return restHighLevelClient.info(RequestOptions.DEFAULT).getVersion().getNumber();
        }
        catch (IOException e) {
            LogUtils.formatWarn("get client version error", new Object[0]);
            return "unknown";
        }
    }

    private EEVersionUtils() {
    }
}

