/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.starter.service.impl;

import cn.easyes.common.enums.ProcessIndexStrategyEnum;
import cn.easyes.common.utils.LogUtils;
import cn.easyes.core.biz.CreateIndexParam;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.biz.EsIndexInfo;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.core.toolkit.IndexUtils;
import cn.easyes.starter.service.AutoProcessIndexService;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnClass(value={RestHighLevelClient.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class AutoProcessIndexNotSmoothlyServiceImpl
implements AutoProcessIndexService {
    @Override
    public Integer getStrategyType() {
        return ProcessIndexStrategyEnum.NOT_SMOOTHLY.getStrategyType();
    }

    @Override
    public void processIndexAsync(Class<?> entityClass, RestHighLevelClient client) {
        LogUtils.info((String[])new String[]{"===> Not smoothly process index mode activated"});
        IndexUtils.supplyAsync(this::process, entityClass, (RestHighLevelClient)client);
    }

    private boolean process(Class<?> entityClass, RestHighLevelClient client) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        boolean existsIndex = IndexUtils.existsIndexWithRetry((EntityInfo)entityInfo, (RestHighLevelClient)client);
        if (existsIndex) {
            return this.doUpdateIndex(entityInfo, client);
        }
        return this.doCreateIndex(entityInfo, client);
    }

    private boolean doUpdateIndex(EntityInfo entityInfo, RestHighLevelClient client) {
        EsIndexInfo esIndexInfo = IndexUtils.getIndexInfo((RestHighLevelClient)client, (String)entityInfo.getRetrySuccessIndexName());
        boolean isIndexNeedChange = IndexUtils.isIndexNeedChange((EsIndexInfo)esIndexInfo, (EntityInfo)entityInfo);
        if (!isIndexNeedChange) {
            LogUtils.info((String[])new String[]{"===> index has nothing changed"});
            entityInfo.setIndexName(entityInfo.getRetrySuccessIndexName());
            return Boolean.TRUE;
        }
        IndexUtils.deleteIndex((RestHighLevelClient)client, (String)entityInfo.getRetrySuccessIndexName());
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam((EntityInfo)entityInfo);
        return IndexUtils.createIndex((RestHighLevelClient)client, (EntityInfo)entityInfo, (CreateIndexParam)createIndexParam);
    }

    private boolean doCreateIndex(EntityInfo entityInfo, RestHighLevelClient client) {
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam((EntityInfo)entityInfo);
        return IndexUtils.createIndex((RestHighLevelClient)client, (EntityInfo)entityInfo, (CreateIndexParam)createIndexParam);
    }
}

