/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.starter.register;

import cn.easyes.annotation.Intercepts;
import cn.easyes.common.enums.ProcessIndexStrategyEnum;
import cn.easyes.common.params.DefaultChildClass;
import cn.easyes.common.utils.LogUtils;
import cn.easyes.common.utils.TypeUtils;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.cache.BaseCache;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.config.GlobalConfig;
import cn.easyes.core.proxy.EsMapperProxy;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.extension.context.Interceptor;
import cn.easyes.extension.context.InterceptorChain;
import cn.easyes.extension.context.InterceptorChainHolder;
import cn.easyes.starter.config.EasyEsConfigProperties;
import cn.easyes.starter.factory.IndexStrategyFactory;
import cn.easyes.starter.service.AutoProcessIndexService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MapperFactoryBean<T>
implements FactoryBean<T> {
    private Class<T> mapperInterface;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IndexStrategyFactory indexStrategyFactory;
    @Autowired
    private EasyEsConfigProperties esConfigProperties;

    public MapperFactoryBean() {
    }

    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public T getObject() throws Exception {
        EsMapperProxy esMapperProxy = new EsMapperProxy(this.mapperInterface);
        Class entityClass = TypeUtils.getInterfaceT(this.mapperInterface, (int)0);
        GlobalConfigCache.setGlobalConfig((GlobalConfig)this.esConfigProperties.getGlobalConfig());
        BaseCache.initCache(this.mapperInterface, (Class)entityClass, (RestHighLevelClient)this.client);
        Object t = Proxy.newProxyInstance(this.mapperInterface.getClassLoader(), new Class[]{this.mapperInterface}, (InvocationHandler)esMapperProxy);
        InterceptorChain interceptorChain = this.initInterceptorChain();
        GlobalConfig globalConfig = this.esConfigProperties.getGlobalConfig();
        if (!ProcessIndexStrategyEnum.MANUAL.equals((Object)globalConfig.getProcessIndexMode())) {
            EntityInfo entityInfo = EntityInfoHelper.getEntityInfo((Class)entityClass);
            if (!entityInfo.isChild()) {
                AutoProcessIndexService autoProcessIndexService = this.indexStrategyFactory.getByStrategyType(globalConfig.getProcessIndexMode().getStrategyType());
                autoProcessIndexService.processIndexAsync(entityClass, this.client);
                if (!DefaultChildClass.class.equals((Object)entityInfo.getChildClass())) {
                    Optional.ofNullable(entityInfo.getChildClass()).flatMap(childClass -> Optional.ofNullable(EntityInfoHelper.getEntityInfo((Class)childClass))).ifPresent(childEntityInfo -> childEntityInfo.setIndexName(entityInfo.getIndexName()));
                }
            }
        } else {
            LogUtils.info((String[])new String[]{"===> manual index mode activated"});
        }
        return (T)interceptorChain.pluginAll(t);
    }

    public Class<?> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterceptorChain initInterceptorChain() {
        InterceptorChainHolder interceptorChainHolder = InterceptorChainHolder.getInstance();
        InterceptorChain interceptorChain = interceptorChainHolder.getInterceptorChain();
        if (interceptorChain == null) {
            MapperFactoryBean mapperFactoryBean = this;
            synchronized (mapperFactoryBean) {
                interceptorChainHolder.initInterceptorChain();
                Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(Intercepts.class);
                beansWithAnnotation.forEach((key, val) -> {
                    if (val instanceof Interceptor) {
                        Interceptor interceptor = (Interceptor)val;
                        interceptorChainHolder.addInterceptor(interceptor);
                    }
                });
            }
        }
        return interceptorChainHolder.getInterceptorChain();
    }
}

