/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.starter.config;

import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.RestHighLevelClientBuilder;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.starter.config.EasyEsConfigProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RestHighLevelClient.class})
@EnableConfigurationProperties(value={EasyEsConfigProperties.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class EsAutoConfiguration {
    @Autowired
    private EasyEsConfigProperties easyEsConfigProperties;

    @Bean
    @ConditionalOnMissingBean
    public RestHighLevelClient restHighLevelClient() {
        boolean needSetRequestConfig;
        boolean needSetHttpClient;
        String address = this.easyEsConfigProperties.getAddress();
        if (StringUtils.isEmpty((CharSequence)address)) {
            throw ExceptionUtils.eee((String)"please config the es address", (Object[])new Object[0]);
        }
        if (!address.contains(":")) {
            throw ExceptionUtils.eee((String)"the address must contains port and separate by ':'", (Object[])new Object[0]);
        }
        String schema = StringUtils.isEmpty((CharSequence)this.easyEsConfigProperties.getSchema()) ? "http" : this.easyEsConfigProperties.getSchema();
        ArrayList hostList = new ArrayList();
        Arrays.stream(this.easyEsConfigProperties.getAddress().split(",")).forEach(item -> hostList.add(new HttpHost(item.split(":")[0], Integer.parseInt(item.split(":")[1]), schema)));
        HttpHost[] httpHost = hostList.toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHost);
        String username = this.easyEsConfigProperties.getUsername();
        String password = this.easyEsConfigProperties.getPassword();
        Integer maxConnTotal = this.easyEsConfigProperties.getMaxConnTotal();
        Integer maxConnPerRoute = this.easyEsConfigProperties.getMaxConnPerRoute();
        Integer keepAliveMillis = this.easyEsConfigProperties.getKeepAliveMillis();
        boolean bl = needSetHttpClient = StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password) || Objects.nonNull(maxConnTotal) || Objects.nonNull(maxConnPerRoute) || Objects.nonNull(keepAliveMillis);
        if (needSetHttpClient) {
            builder.setHttpClientConfigCallback(httpClientBuilder -> {
                Optional.ofNullable(keepAliveMillis).ifPresent(p -> httpClientBuilder.setKeepAliveStrategy((response, context) -> p.intValue()));
                Optional.ofNullable(maxConnTotal).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnTotal(arg_0));
                Optional.ofNullable(maxConnPerRoute).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnPerRoute(arg_0));
                if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.easyEsConfigProperties.getUsername(), this.easyEsConfigProperties.getPassword()));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                return httpClientBuilder;
            });
        }
        Integer connectTimeOut = this.easyEsConfigProperties.getConnectTimeout();
        Integer socketTimeOut = this.easyEsConfigProperties.getSocketTimeout();
        Integer connectionRequestTimeOut = this.easyEsConfigProperties.getConnectionRequestTimeout();
        boolean bl2 = needSetRequestConfig = Objects.nonNull(connectTimeOut) || Objects.nonNull(connectionRequestTimeOut);
        if (needSetRequestConfig) {
            builder.setRequestConfigCallback(requestConfigBuilder -> {
                Optional.ofNullable(connectTimeOut).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectTimeout(arg_0));
                Optional.ofNullable(socketTimeOut).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setSocketTimeout(arg_0));
                Optional.ofNullable(connectionRequestTimeOut).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectionRequestTimeout(arg_0));
                return requestConfigBuilder;
            });
        }
        return RestHighLevelClientBuilder.build((RestClientBuilder)builder);
    }
}

