/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.starter.nacos.refresh;

import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.common.util.NacosUtil;
import com.dtp.core.refresh.AbstractRefresher;
import com.dtp.core.support.ThreadPoolCreator;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;

public class NacosRefresher
extends AbstractRefresher
implements InitializingBean,
Listener {
    private static final Logger log = LoggerFactory.getLogger(NacosRefresher.class);
    private static final ThreadPoolExecutor EXECUTOR = ThreadPoolCreator.createCommonFast((String)"nacos-listener");
    private ConfigFileTypeEnum configFileType;
    @NacosInjected
    private ConfigService configService;
    @Resource
    private Environment environment;

    public void afterPropertiesSet() {
        DtpProperties.Nacos nacos = this.dtpProperties.getNacos();
        this.configFileType = NacosUtil.getConfigType((DtpProperties)this.dtpProperties, (ConfigFileTypeEnum)ConfigFileTypeEnum.PROPERTIES);
        String dataId = NacosUtil.deduceDataId((DtpProperties.Nacos)nacos, (Environment)this.environment, (ConfigFileTypeEnum)this.configFileType);
        String group = NacosUtil.getGroup((DtpProperties.Nacos)nacos, (String)"DEFAULT_GROUP");
        try {
            this.configService.addListener(dataId, group, (Listener)this);
            log.info("DynamicTp refresher, add listener success, dataId: {}, group: {}", (Object)dataId, (Object)group);
        }
        catch (NacosException e) {
            log.error("DynamicTp refresher, add listener error, dataId: {}, group: {}", new Object[]{dataId, group, e});
        }
    }

    public Executor getExecutor() {
        return EXECUTOR;
    }

    public void receiveConfigInfo(String content) {
        this.refresh(content, this.configFileType);
    }
}

