/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.thread;

import cn.hutool.core.util.StrUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean daemon;
    private final Integer priority;
    private final AtomicInteger seq = new AtomicInteger(1);
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public NamedThreadFactory(String namePrefix, boolean daemon, int priority) {
        this.daemon = daemon;
        this.priority = priority;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix;
        this.uncaughtExceptionHandler = new DtpUncaughtExceptionHandler();
    }

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false, 5);
    }

    public NamedThreadFactory(String namePrefix, boolean daemon) {
        this(namePrefix, daemon, 5);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, StrUtil.format((CharSequence)"{}-{}", (Object[])new Object[]{this.namePrefix, this.seq.getAndIncrement()}));
        t.setDaemon(this.daemon);
        t.setPriority(this.priority);
        t.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        return t;
    }

    public static class DtpUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("thread {} throw exception {}", (Object)t, (Object)e);
        }
    }
}

