/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.thread;

import com.dtp.core.support.TaskQueue;
import com.dtp.core.thread.DtpExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EagerDtpExecutor
extends DtpExecutor {
    private final AtomicInteger submittedTaskCount = new AtomicInteger(0);

    public EagerDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public int getSubmittedTaskCount() {
        return this.submittedTaskCount.get();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedTaskCount.decrementAndGet();
        super.afterExecute(r, t);
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.submittedTaskCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            if (this.getQueue() instanceof TaskQueue) {
                TaskQueue queue = (TaskQueue)((Object)this.getQueue());
                try {
                    if (!queue.force(command, 0L, TimeUnit.MILLISECONDS)) {
                        this.submittedTaskCount.decrementAndGet();
                        throw new RejectedExecutionException("Queue capacity is full.", rx);
                    }
                }
                catch (InterruptedException x) {
                    this.submittedTaskCount.decrementAndGet();
                    throw new RejectedExecutionException(x);
                }
            }
            this.submittedTaskCount.decrementAndGet();
            throw rx;
        }
    }
}

