/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.thread;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.core.notify.manager.AlarmManager;
import com.dtp.core.reject.RejectHandlerGetter;
import com.dtp.core.spring.DtpLifecycleSupport;
import com.dtp.core.support.runnable.DtpRunnable;
import com.dtp.core.support.runnable.NamedRunnable;
import com.dtp.core.support.wrapper.TaskWrapper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpExecutor
extends DtpLifecycleSupport {
    private static final Logger log = LoggerFactory.getLogger(DtpExecutor.class);
    private final AtomicInteger rejectCount = new AtomicInteger(0);
    private String rejectHandlerName;
    private String threadPoolAliasName;
    private List<NotifyItem> notifyItems;
    private List<TaskWrapper> taskWrappers = Lists.newArrayList();
    private boolean preStartAllCoreThreads;
    private long runTimeout;
    private long queueTimeout;
    private final AtomicInteger runTimeoutCount = new AtomicInteger();
    private final AtomicInteger queueTimeoutCount = new AtomicInteger();

    public DtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.rejectHandlerName = handler.getClass().getSimpleName();
        RejectedExecutionHandler rejectedExecutionHandler = RejectHandlerGetter.getProxy(handler);
        this.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    @Override
    public void execute(Runnable command) {
        String taskName = null;
        if (command instanceof NamedRunnable) {
            taskName = ((NamedRunnable)command).getName();
        }
        if (CollUtil.isNotEmpty(this.taskWrappers)) {
            for (TaskWrapper t : this.taskWrappers) {
                command = t.wrap(command);
            }
        }
        if (this.runTimeout > 0L || this.queueTimeout > 0L) {
            command = new DtpRunnable(command, taskName);
        }
        super.execute(command);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        long waitTime;
        if (!(r instanceof DtpRunnable)) {
            super.beforeExecute(t, r);
            return;
        }
        DtpRunnable runnable = (DtpRunnable)r;
        long currTime = System.currentTimeMillis();
        if (this.runTimeout > 0L) {
            runnable.setStartTime(currTime);
        }
        if (this.queueTimeout > 0L && (waitTime = currTime - runnable.getSubmitTime()) > this.queueTimeout) {
            this.queueTimeoutCount.incrementAndGet();
            Runnable alarmTask = () -> AlarmManager.doAlarm(this, NotifyItemEnum.QUEUE_TIMEOUT);
            AlarmManager.triggerAlarm(this.getThreadPoolName(), NotifyItemEnum.QUEUE_TIMEOUT.getValue(), alarmTask);
            if (StringUtils.isNotBlank((CharSequence)runnable.getTaskName())) {
                log.warn("DynamicTp execute, queue timeout, poolName: {}, taskName: {}, waitTime: {}ms", new Object[]{this.getThreadPoolName(), runnable.getTaskName(), waitTime});
            }
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (this.runTimeout > 0L) {
            DtpRunnable runnable = (DtpRunnable)r;
            long runTime = System.currentTimeMillis() - runnable.getStartTime();
            if (runTime > this.runTimeout) {
                this.runTimeoutCount.incrementAndGet();
                Runnable alarmTask = () -> AlarmManager.doAlarm(this, NotifyItemEnum.RUN_TIMEOUT);
                AlarmManager.triggerAlarm(this.getThreadPoolName(), NotifyItemEnum.RUN_TIMEOUT.getValue(), alarmTask);
                if (StringUtils.isNotBlank((CharSequence)runnable.getTaskName())) {
                    log.warn("DynamicTp execute, run timeout, poolName: {}, taskName: {}, runTime: {}ms", new Object[]{this.getThreadPoolName(), runnable.getTaskName(), runTime});
                }
            }
        }
        super.afterExecute(r, t);
    }

    @Override
    protected void initialize(DtpProperties dtpProperties) {
        AlarmManager.initAlarm(this, dtpProperties.getPlatforms());
        if (this.preStartAllCoreThreads) {
            this.prestartAllCoreThreads();
        }
    }

    public void incRejectCount(int count) {
        this.rejectCount.addAndGet(count);
    }

    public int getRejectCount() {
        return this.rejectCount.get();
    }

    public List<NotifyItem> getNotifyItems() {
        return this.notifyItems;
    }

    public void setNotifyItems(List<NotifyItem> notifyItems) {
        this.notifyItems = notifyItems;
    }

    public String getQueueName() {
        return this.getQueue().getClass().getSimpleName();
    }

    public int getQueueCapacity() {
        int capacity = this.getQueue().size() + this.getQueue().remainingCapacity();
        return capacity < 0 ? Integer.MAX_VALUE : capacity;
    }

    public String getRejectHandlerName() {
        return this.rejectHandlerName;
    }

    public void setRejectHandlerName(String rejectHandlerName) {
        this.rejectHandlerName = rejectHandlerName;
    }

    public void setTaskWrappers(List<TaskWrapper> taskWrappers) {
        this.taskWrappers = taskWrappers;
    }

    public void setPreStartAllCoreThreads(boolean preStartAllCoreThreads) {
        this.preStartAllCoreThreads = preStartAllCoreThreads;
    }

    public void setRunTimeout(long runTimeout) {
        this.runTimeout = runTimeout;
    }

    public int getRunTimeoutCount() {
        return this.runTimeoutCount.get();
    }

    public int getQueueTimeoutCount() {
        return this.queueTimeoutCount.get();
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    public String getThreadPoolAliasName() {
        return this.threadPoolAliasName;
    }

    public void setThreadPoolAliasName(String threadPoolAliasName) {
        this.threadPoolAliasName = threadPoolAliasName;
    }
}

