/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.support.runnable;

import cn.hutool.core.map.MapUtil;
import java.util.Map;
import org.slf4j.MDC;

public class MdcRunnable
implements Runnable {
    private final Runnable runnable;
    private final Map<String, String> parentMdc;

    public MdcRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.parentMdc = MDC.getCopyOfContextMap();
    }

    public static MdcRunnable get(Runnable runnable) {
        return new MdcRunnable(runnable);
    }

    @Override
    public void run() {
        if (MapUtil.isEmpty(this.parentMdc)) {
            this.runnable.run();
            return;
        }
        for (Map.Entry<String, String> entry : this.parentMdc.entrySet()) {
            MDC.put((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            this.runnable.run();
        }
        finally {
            for (Map.Entry<String, String> entry : this.parentMdc.entrySet()) {
                MDC.remove((String)entry.getKey());
            }
        }
    }
}

