/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.support;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.dtp.common.constant.DynamicTpConst;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.queue.VariableLinkedBlockingQueue;
import com.dtp.core.reject.RejectHandlerGetter;
import com.dtp.core.support.TaskQueue;
import com.dtp.core.support.wrapper.TaskWrapper;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.EagerDtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ThreadPoolBuilder {
    private String threadPoolName = "DynamicTp";
    private int corePoolSize = 1;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private long keepAliveTime = 30L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private BlockingQueue<Runnable> workQueue = new VariableLinkedBlockingQueue(1024);
    private int queueCapacity = 1024;
    private int maxFreeMemory = 256;
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ThreadFactory threadFactory = new NamedThreadFactory("dtp");
    private boolean allowCoreThreadTimeOut = false;
    private boolean dynamic = true;
    private boolean waitForTasksToCompleteOnShutdown = false;
    private int awaitTerminationSeconds = 0;
    private boolean ioIntensive = false;
    private boolean preStartAllCoreThreads = false;
    private long runTimeout = 0L;
    private long queueTimeout = 0L;
    private final List<TaskWrapper> taskWrappers = Lists.newArrayList();
    private List<NotifyItem> notifyItems = NotifyItem.getAllNotifyItems();

    private ThreadPoolBuilder() {
    }

    public static ThreadPoolBuilder newBuilder() {
        return new ThreadPoolBuilder();
    }

    public ThreadPoolBuilder threadPoolName(String poolName) {
        this.threadPoolName = poolName;
        return this;
    }

    public ThreadPoolBuilder corePoolSize(int corePoolSize) {
        if (corePoolSize >= 0) {
            this.corePoolSize = corePoolSize;
        }
        return this;
    }

    public ThreadPoolBuilder maximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize > 0) {
            this.maximumPoolSize = maximumPoolSize;
        }
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        if (keepAliveTime > 0L) {
            this.keepAliveTime = keepAliveTime;
        }
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit timeUnit) {
        if (timeUnit != null) {
            this.timeUnit = timeUnit;
        }
        return this;
    }

    public ThreadPoolBuilder workQueue(String queueName, Integer capacity, Boolean fair, Integer maxFreeMemory) {
        if (StringUtils.isNotBlank((CharSequence)queueName)) {
            this.workQueue = QueueTypeEnum.buildLbq((String)queueName, (int)(capacity != null ? capacity : this.queueCapacity), (fair != null && fair != false ? 1 : 0) != 0, (int)(maxFreeMemory != null ? maxFreeMemory : this.maxFreeMemory));
        }
        return this;
    }

    public ThreadPoolBuilder workQueue(String queueName, Integer capacity, Boolean fair) {
        if (StringUtils.isNotBlank((CharSequence)queueName)) {
            this.workQueue = QueueTypeEnum.buildLbq((String)queueName, (int)(capacity != null ? capacity : this.queueCapacity), (fair != null && fair != false ? 1 : 0) != 0, (int)this.maxFreeMemory);
        }
        return this;
    }

    public ThreadPoolBuilder queueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public ThreadPoolBuilder maxFreeMemory(int maxFreeMemory) {
        this.maxFreeMemory = maxFreeMemory;
        return this;
    }

    public ThreadPoolBuilder rejectedExecutionHandler(String rejectedName) {
        if (StringUtils.isNotBlank((CharSequence)rejectedName)) {
            this.rejectedExecutionHandler = RejectHandlerGetter.buildRejectedHandler(rejectedName);
        }
        return this;
    }

    public ThreadPoolBuilder threadFactory(String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            this.threadFactory = new NamedThreadFactory(prefix);
        }
        return this;
    }

    public ThreadPoolBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public ThreadPoolBuilder dynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public ThreadPoolBuilder awaitTerminationSeconds(int awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        return this;
    }

    public ThreadPoolBuilder waitForTasksToCompleteOnShutdown(boolean waitForTasksToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
        return this;
    }

    public ThreadPoolBuilder ioIntensive(boolean ioIntensive) {
        this.ioIntensive = ioIntensive;
        return this;
    }

    public ThreadPoolBuilder preStartAllCoreThreads(boolean preStartAllCoreThreads) {
        this.preStartAllCoreThreads = preStartAllCoreThreads;
        return this;
    }

    public ThreadPoolBuilder runTimeout(long runTimeout) {
        this.runTimeout = runTimeout;
        return this;
    }

    public ThreadPoolBuilder queueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
        return this;
    }

    public ThreadPoolBuilder taskWrappers(List<TaskWrapper> taskWrappers) {
        this.taskWrappers.addAll(taskWrappers);
        return this;
    }

    public ThreadPoolBuilder taskWrapper(TaskWrapper taskWrapper) {
        this.taskWrappers.add(taskWrapper);
        return this;
    }

    public ThreadPoolBuilder notifyItems(List<NotifyItem> notifyItemList) {
        if (CollUtil.isNotEmpty(notifyItemList)) {
            this.notifyItems = notifyItemList;
        }
        return this;
    }

    public ThreadPoolExecutor build() {
        if (this.dynamic) {
            return this.buildDtpExecutor(this);
        }
        return this.buildCommonExecutor(this);
    }

    public DtpExecutor buildDynamic() {
        return this.buildDtpExecutor(this);
    }

    public ThreadPoolExecutor buildCommon() {
        return this.buildCommonExecutor(this);
    }

    public ExecutorService buildWithTtl() {
        if (this.dynamic) {
            this.taskWrappers.add(TtlRunnable::get);
            return this.buildDtpExecutor(this);
        }
        return TtlExecutors.getTtlExecutorService((ExecutorService)this.buildCommonExecutor(this));
    }

    private DtpExecutor buildDtpExecutor(ThreadPoolBuilder builder) {
        Assert.notNull((Object)builder.threadPoolName, (String)"The thread pool name must not be null.");
        DtpExecutor dtpExecutor = this.createInternal(builder);
        dtpExecutor.setThreadPoolName(builder.threadPoolName);
        dtpExecutor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        dtpExecutor.setWaitForTasksToCompleteOnShutdown(builder.waitForTasksToCompleteOnShutdown);
        dtpExecutor.setAwaitTerminationSeconds(builder.awaitTerminationSeconds);
        dtpExecutor.setPreStartAllCoreThreads(builder.preStartAllCoreThreads);
        dtpExecutor.setRunTimeout(builder.runTimeout);
        dtpExecutor.setQueueTimeout(builder.queueTimeout);
        dtpExecutor.setTaskWrappers(builder.taskWrappers);
        dtpExecutor.setNotifyItems(builder.notifyItems);
        return dtpExecutor;
    }

    private DtpExecutor createInternal(ThreadPoolBuilder builder) {
        DtpExecutor dtpExecutor;
        if (this.ioIntensive) {
            TaskQueue taskQueue = new TaskQueue(builder.queueCapacity, builder.maxFreeMemory * DynamicTpConst.M_1);
            dtpExecutor = new EagerDtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, (BlockingQueue<Runnable>)((Object)taskQueue), builder.threadFactory, builder.rejectedExecutionHandler);
            taskQueue.setExecutor((EagerDtpExecutor)dtpExecutor);
        } else {
            dtpExecutor = new DtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler);
        }
        return dtpExecutor;
    }

    private ThreadPoolExecutor buildCommonExecutor(ThreadPoolBuilder builder) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler);
        executor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        return executor;
    }
}

