/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.support;

import com.dtp.common.queue.MemorySafeLinkedBlockingQueue;
import com.dtp.core.thread.EagerDtpExecutor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.NonNull;

public class TaskQueue
extends MemorySafeLinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = -1L;
    private transient EagerDtpExecutor executor;

    public TaskQueue(int queueCapacity, int maxFreeMemory) {
        super(queueCapacity, maxFreeMemory);
    }

    public void setExecutor(EagerDtpExecutor exec) {
        this.executor = exec;
    }

    public boolean offer(@NonNull Runnable runnable) {
        if (this.executor == null) {
            throw new RejectedExecutionException("The task queue does not have executor.");
        }
        int currentPoolThreadSize = this.executor.getPoolSize();
        if (currentPoolThreadSize == this.executor.getMaximumPoolSize()) {
            return super.offer((Object)runnable);
        }
        if (this.executor.getSubmittedTaskCount() < currentPoolThreadSize) {
            return super.offer((Object)runnable);
        }
        if (currentPoolThreadSize < this.executor.getMaximumPoolSize()) {
            return false;
        }
        return super.offer((Object)runnable);
    }

    public boolean force(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executor.isShutdown()) {
            throw new RejectedExecutionException("Executor is shutdown.");
        }
        return super.offer((Object)o, timeout, unit);
    }
}

