/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.spring;

import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.core.DtpRegistry;
import com.dtp.core.support.DynamicTp;
import com.dtp.core.support.TaskQueue;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.EagerDtpExecutor;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DtpPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DtpPostProcessor.class);

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        String poolName;
        String dtpAnnotationVal;
        if (!(bean instanceof ThreadPoolExecutor) && !(bean instanceof ThreadPoolTaskExecutor)) {
            return bean;
        }
        if (bean instanceof DtpExecutor) {
            DtpExecutor dtpExecutor = (DtpExecutor)bean;
            if (bean instanceof EagerDtpExecutor) {
                ((TaskQueue)((Object)dtpExecutor.getQueue())).setExecutor((EagerDtpExecutor)dtpExecutor);
            }
            this.registerDtp(dtpExecutor);
            return dtpExecutor;
        }
        ApplicationContext applicationContext = ApplicationContextHolder.getInstance();
        try {
            DynamicTp dynamicTp = (DynamicTp)applicationContext.findAnnotationOnBean(beanName, DynamicTp.class);
            if (Objects.nonNull(dynamicTp)) {
                dtpAnnotationVal = dynamicTp.value();
            } else {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)applicationContext;
                AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)registry.getBeanDefinition(beanName);
                MethodMetadata methodMetadata = (MethodMetadata)annotatedBeanDefinition.getSource();
                if (Objects.isNull(methodMetadata) || !methodMetadata.isAnnotated(DynamicTp.class.getName())) {
                    return bean;
                }
                dtpAnnotationVal = Optional.ofNullable(methodMetadata.getAnnotationAttributes(DynamicTp.class.getName())).orElse(Collections.emptyMap()).getOrDefault("value", "").toString();
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("There is no bean with the given name {}", (Object)beanName, (Object)e);
            return bean;
        }
        String string = poolName = StringUtils.isNotBlank((CharSequence)dtpAnnotationVal) ? dtpAnnotationVal : beanName;
        if (bean instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor taskExecutor = (ThreadPoolTaskExecutor)bean;
            this.registerCommon(poolName, taskExecutor.getThreadPoolExecutor());
        } else {
            this.registerCommon(poolName, (ThreadPoolExecutor)bean);
        }
        return bean;
    }

    private void registerDtp(DtpExecutor executor) {
        DtpRegistry.registerDtp(executor, "beanPostProcessor");
    }

    private void registerCommon(String poolName, ThreadPoolExecutor executor) {
        ExecutorWrapper wrapper = new ExecutorWrapper(poolName, (Executor)executor);
        DtpRegistry.registerCommon(wrapper, "beanPostProcessor");
    }
}

