/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.reject;

import com.dtp.common.em.RejectedTypeEnum;
import com.dtp.common.ex.DtpException;
import com.dtp.core.reject.RejectedInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectHandlerGetter {
    private static final Logger log = LoggerFactory.getLogger(RejectHandlerGetter.class);

    private RejectHandlerGetter() {
    }

    public static RejectedExecutionHandler buildRejectedHandler(String name) {
        if (Objects.equals(name, RejectedTypeEnum.ABORT_POLICY.getName())) {
            return new ThreadPoolExecutor.AbortPolicy();
        }
        if (Objects.equals(name, RejectedTypeEnum.CALLER_RUNS_POLICY.getName())) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        if (Objects.equals(name, RejectedTypeEnum.DISCARD_OLDEST_POLICY.getName())) {
            return new ThreadPoolExecutor.DiscardOldestPolicy();
        }
        if (Objects.equals(name, RejectedTypeEnum.DISCARD_POLICY.getName())) {
            return new ThreadPoolExecutor.DiscardPolicy();
        }
        ServiceLoader<RejectedExecutionHandler> serviceLoader = ServiceLoader.load(RejectedExecutionHandler.class);
        for (RejectedExecutionHandler handler : serviceLoader) {
            String handlerName = handler.getClass().getSimpleName();
            if (!name.equalsIgnoreCase(handlerName)) continue;
            return handler;
        }
        log.error("Cannot find specified rejectedHandler {}", (Object)name);
        throw new DtpException("Cannot find specified rejectedHandler " + name);
    }

    public static RejectedExecutionHandler getProxy(String name) {
        return RejectHandlerGetter.getProxy(RejectHandlerGetter.buildRejectedHandler(name));
    }

    public static RejectedExecutionHandler getProxy(RejectedExecutionHandler handler) {
        return (RejectedExecutionHandler)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{RejectedExecutionHandler.class}, (InvocationHandler)new RejectedInvocationHandler(handler));
    }
}

