/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.manager;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.core.thread.DtpExecutor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyItemManager {
    private static final Logger log = LoggerFactory.getLogger(NotifyItemManager.class);
    private static final List<String> COMMON_ALARM_KEYS = Lists.newArrayList((Object[])new String[]{"alarmType", "threshold"});
    private static final Set<String> LIVENESS_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"corePoolSize", "maximumPoolSize", "poolSize", "activeCount"});
    private static final Set<String> CAPACITY_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"queueType", "queueCapacity", "queueSize", "queueRemaining"});
    private static final Set<String> REJECT_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"rejectType", "rejectCount"});
    private static final Set<String> RUN_TIMEOUT_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"runTimeoutCount"});
    private static final Set<String> QUEUE_TIMEOUT_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"queueTimeoutCount"});
    private static final Set<String> ALL_ALARM_KEYS;
    private static final Map<String, Set<String>> ALARM_KEYS;

    private NotifyItemManager() {
    }

    public static Set<String> getAllAlarmKeys() {
        return ALL_ALARM_KEYS;
    }

    public static Set<String> getAlarmKeys(NotifyItemEnum notifyItemEnum) {
        Set<String> keys = ALARM_KEYS.get(notifyItemEnum.name());
        keys.addAll(COMMON_ALARM_KEYS);
        return keys;
    }

    public static NotifyItem getNotifyItem(DtpExecutor executor, NotifyItemEnum notifyItemEnum) {
        ExecutorWrapper executorWrapper = new ExecutorWrapper(executor.getThreadPoolName(), (Executor)executor, executor.getNotifyItems());
        return NotifyItemManager.getNotifyItem(executorWrapper, notifyItemEnum);
    }

    public static NotifyItem getNotifyItem(ExecutorWrapper executorWrapper, NotifyItemEnum notifyItemEnum) {
        List notifyItems = executorWrapper.getNotifyItems();
        Optional<NotifyItem> notifyItemOpt = notifyItems.stream().filter(x -> notifyItemEnum.getValue().equalsIgnoreCase(x.getType())).findFirst();
        if (!notifyItemOpt.isPresent()) {
            log.debug("DynamicTp notify, no such [{}] notify item configured, threadPoolName: {}", (Object)notifyItemEnum.getValue(), (Object)executorWrapper.getThreadPoolName());
            return null;
        }
        return notifyItemOpt.get();
    }

    public static void fillPlatforms(List<NotifyPlatform> platforms, List<NotifyItem> notifyItems) {
        if (CollUtil.isEmpty(platforms) || CollUtil.isEmpty(notifyItems)) {
            log.warn("DynamicTp notify, no notify platforms or items configured.");
            return;
        }
        List platformNames = platforms.stream().map(NotifyPlatform::getPlatform).collect(Collectors.toList());
        notifyItems.forEach(n -> {
            if (CollUtil.isEmpty((Collection)n.getPlatforms())) {
                n.setPlatforms(platformNames);
            }
        });
    }

    static {
        ALARM_KEYS = Maps.newHashMap();
        ALARM_KEYS.put(NotifyItemEnum.LIVENESS.name(), LIVENESS_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.CAPACITY.name(), CAPACITY_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.REJECT.name(), REJECT_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.RUN_TIMEOUT.name(), RUN_TIMEOUT_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.QUEUE_TIMEOUT.name(), QUEUE_TIMEOUT_ALARM_KEYS);
        ALL_ALARM_KEYS = ALARM_KEYS.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        ALL_ALARM_KEYS.addAll(COMMON_ALARM_KEYS);
    }
}

