/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.manager;

import com.dtp.common.pattern.filter.FilterChain;
import com.dtp.core.context.BaseNotifyCtx;
import com.dtp.core.context.NoticeCtx;
import com.dtp.core.notify.manager.NotifyFilterBuilder;
import com.dtp.core.support.ThreadPoolCreator;
import java.util.concurrent.ExecutorService;

public class NoticeManager {
    private static final ExecutorService NOTICE_EXECUTOR = ThreadPoolCreator.createCommonFast("dtp-notify");
    private static final FilterChain<BaseNotifyCtx> NOTICE_FILTER_CHAIN = NotifyFilterBuilder.getCommonNoticeFilter();

    private NoticeManager() {
    }

    public static void doNotice(NoticeCtx noticeCtx) {
        NOTICE_FILTER_CHAIN.fire((Object)noticeCtx);
    }

    public static void doNoticeAsync(NoticeCtx noticeCtx) {
        NOTICE_EXECUTOR.execute(() -> NoticeManager.doNotice(noticeCtx));
    }
}

