/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.em.RejectedTypeEnum;
import com.dtp.common.pattern.filter.FilterChain;
import com.dtp.common.util.StreamUtil;
import com.dtp.core.context.AlarmCtx;
import com.dtp.core.context.BaseNotifyCtx;
import com.dtp.core.notify.alarm.AlarmCounter;
import com.dtp.core.notify.alarm.AlarmLimiter;
import com.dtp.core.notify.manager.NotifyFilterBuilder;
import com.dtp.core.notify.manager.NotifyItemManager;
import com.dtp.core.support.ThreadPoolBuilder;
import com.dtp.core.thread.DtpExecutor;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AlarmManager {
    private static final Logger log = LoggerFactory.getLogger(AlarmManager.class);
    private static final ExecutorService ALARM_EXECUTOR = ThreadPoolBuilder.newBuilder().threadPoolName("dtp-alarm").threadFactory("dtp-alarm").corePoolSize(2).maximumPoolSize(4).workQueue(QueueTypeEnum.LINKED_BLOCKING_QUEUE.getName(), 2000, false, null).rejectedExecutionHandler(RejectedTypeEnum.DISCARD_OLDEST_POLICY.getName()).buildCommon();
    private static final FilterChain<BaseNotifyCtx> ALARM_FILTER_CHAIN = NotifyFilterBuilder.getAlarmNoticeFilter();

    private AlarmManager() {
    }

    public static void initAlarm(DtpExecutor executor, List<NotifyPlatform> platforms) {
        if (CollUtil.isEmpty(platforms)) {
            executor.setNotifyItems(Lists.newArrayList());
            return;
        }
        if (CollUtil.isEmpty(executor.getNotifyItems())) {
            log.warn("DynamicTp notify, no notify items configured, name {}", (Object)executor.getThreadPoolName());
            return;
        }
        NotifyItemManager.fillPlatforms(platforms, executor.getNotifyItems());
        AlarmManager.initAlarm(executor.getThreadPoolName(), executor.getNotifyItems());
    }

    public static void initAlarm(String poolName, List<NotifyItem> notifyItems) {
        notifyItems.forEach(x -> {
            AlarmLimiter.initAlarmLimiter(poolName, x);
            AlarmCounter.init(poolName, x.getType());
        });
    }

    public static void refreshAlarm(String poolName, List<NotifyPlatform> platforms, List<NotifyItem> oldItems, List<NotifyItem> newItems) {
        if (CollectionUtils.isEmpty(newItems)) {
            return;
        }
        NotifyItemManager.fillPlatforms(platforms, newItems);
        Map oldNotifyItemMap = StreamUtil.toMap(oldItems, NotifyItem::getType);
        newItems.forEach(x -> {
            NotifyItem oldNotifyItem = (NotifyItem)oldNotifyItemMap.get(x.getType());
            if (Objects.nonNull(oldNotifyItem) && oldNotifyItem.getInterval() == x.getInterval()) {
                return;
            }
            AlarmLimiter.initAlarmLimiter(poolName, x);
            AlarmCounter.init(poolName, x.getType());
        });
    }

    public static void triggerAlarm(String dtpName, String notifyType, Runnable runnable) {
        AlarmCounter.incAlarmCounter(dtpName, notifyType);
        ALARM_EXECUTOR.execute(runnable);
    }

    public static void triggerAlarm(Runnable runnable) {
        ALARM_EXECUTOR.execute(runnable);
    }

    public static void doAlarm(DtpExecutor executor, List<NotifyItemEnum> notifyItemEnums) {
        ExecutorWrapper executorWrapper = new ExecutorWrapper(executor.getThreadPoolName(), (Executor)executor, executor.getNotifyItems());
        AlarmManager.doAlarm(executorWrapper, notifyItemEnums);
    }

    public static void doAlarm(ExecutorWrapper executorWrapper, List<NotifyItemEnum> notifyItemEnums) {
        notifyItemEnums.forEach(x -> AlarmManager.doAlarm(executorWrapper, x));
    }

    public static void doAlarm(DtpExecutor executor, NotifyItemEnum notifyItemEnum) {
        ExecutorWrapper executorWrapper = new ExecutorWrapper(executor.getThreadPoolName(), (Executor)executor, executor.getNotifyItems());
        AlarmManager.doAlarm(executorWrapper, notifyItemEnum);
    }

    public static void doAlarm(ExecutorWrapper executorWrapper, NotifyItemEnum notifyItemEnum) {
        NotifyItem notifyItem = NotifyItemManager.getNotifyItem(executorWrapper, notifyItemEnum);
        if (notifyItem == null) {
            return;
        }
        AlarmCtx alarmCtx = new AlarmCtx(executorWrapper, notifyItem);
        ALARM_FILTER_CHAIN.fire((Object)alarmCtx);
    }

    public static boolean checkThreshold(ExecutorWrapper executor, NotifyItemEnum itemEnum, NotifyItem notifyItem) {
        switch (itemEnum) {
            case CAPACITY: {
                return AlarmManager.checkCapacity(executor, notifyItem);
            }
            case LIVENESS: {
                return AlarmManager.checkLiveness(executor, notifyItem);
            }
            case REJECT: 
            case RUN_TIMEOUT: 
            case QUEUE_TIMEOUT: {
                return AlarmManager.checkWithAlarmInfo(executor, notifyItem);
            }
        }
        log.error("Unsupported alarm type, type: {}", (Object)itemEnum);
        return false;
    }

    public static boolean satisfyBaseCondition(NotifyItem notifyItem) {
        return notifyItem.isEnabled() && CollUtil.isNotEmpty((Collection)notifyItem.getPlatforms());
    }

    private static boolean checkLiveness(ExecutorWrapper executorWrapper, NotifyItem notifyItem) {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)executorWrapper.getExecutor();
        int maximumPoolSize = executor.getMaximumPoolSize();
        double div = NumberUtil.div((float)executor.getActiveCount(), (float)maximumPoolSize, (int)2) * 100.0;
        return div >= (double)notifyItem.getThreshold();
    }

    private static boolean checkCapacity(ExecutorWrapper executorWrapper, NotifyItem notifyItem) {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)executorWrapper.getExecutor();
        BlockingQueue<Runnable> workQueue = executor.getQueue();
        if (CollUtil.isEmpty(workQueue)) {
            return false;
        }
        int queueCapacity = executor.getQueue().size() + executor.getQueue().remainingCapacity();
        double div = NumberUtil.div((float)workQueue.size(), (float)queueCapacity, (int)2) * 100.0;
        return div >= (double)notifyItem.getThreshold();
    }

    private static boolean checkWithAlarmInfo(ExecutorWrapper executorWrapper, NotifyItem notifyItem) {
        AlarmInfo alarmInfo = AlarmCounter.getAlarmInfo(executorWrapper.getThreadPoolName(), notifyItem.getType());
        return alarmInfo.getCount() >= notifyItem.getThreshold();
    }
}

