/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.invoker;

import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.common.pattern.filter.Invoker;
import com.dtp.core.context.AlarmCtx;
import com.dtp.core.context.BaseNotifyCtx;
import com.dtp.core.context.DtpNotifyCtxHolder;
import com.dtp.core.handler.NotifierHandler;
import com.dtp.core.notify.alarm.AlarmCounter;

public class AlarmInvoker
implements Invoker<BaseNotifyCtx> {
    public void invoke(BaseNotifyCtx context) {
        AlarmCtx alarmCtx = (AlarmCtx)context;
        ExecutorWrapper executorWrapper = alarmCtx.getExecutorWrapper();
        NotifyItem notifyItem = alarmCtx.getNotifyItem();
        NotifyItemEnum notifyItemEnum = NotifyItemEnum.of((String)notifyItem.getType());
        DtpProperties dtpProperties = (DtpProperties)ApplicationContextHolder.getBean(DtpProperties.class);
        AlarmInfo alarmInfo = AlarmCounter.getAlarmInfo(executorWrapper.getThreadPoolName(), notifyItem.getType());
        context.setPlatforms(dtpProperties.getPlatforms());
        alarmCtx.setAlarmInfo(alarmInfo);
        DtpNotifyCtxHolder.set(context);
        NotifierHandler.getInstance().sendAlarm(notifyItemEnum);
        AlarmCounter.reset(executorWrapper.getThreadPoolName(), notifyItem.getType());
    }
}

