/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.filter;

import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.common.pattern.filter.Invoker;
import com.dtp.core.context.BaseNotifyCtx;
import com.dtp.core.notify.alarm.AlarmLimiter;
import com.dtp.core.notify.filter.NotifyFilter;
import com.dtp.core.notify.manager.AlarmManager;
import com.dtp.core.notify.manager.NotifyItemManager;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmBaseFilter
implements NotifyFilter {
    private static final Logger log = LoggerFactory.getLogger(AlarmBaseFilter.class);
    private static final Object SEND_LOCK = new Object();

    public int getOrder() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(BaseNotifyCtx context, Invoker<BaseNotifyCtx> nextFilter) {
        NotifyItemEnum notifyItemEnum;
        ExecutorWrapper executorWrapper = context.getExecutorWrapper();
        NotifyItem notifyItem = NotifyItemManager.getNotifyItem(executorWrapper, notifyItemEnum = context.getNotifyItemEnum());
        if (Objects.isNull(notifyItem) || !AlarmManager.satisfyBaseCondition(notifyItem)) {
            return;
        }
        boolean ifAlarm = AlarmLimiter.ifAlarm(executorWrapper.getThreadPoolName(), notifyItemEnum.getValue());
        if (!ifAlarm) {
            log.debug("DynamicTp notify, alarm limit, dtpName: {}, notifyItem: {}", (Object)executorWrapper.getThreadPoolName(), (Object)notifyItemEnum.getValue());
            return;
        }
        if (!AlarmManager.checkThreshold(executorWrapper, notifyItemEnum, notifyItem)) {
            return;
        }
        Object object = SEND_LOCK;
        synchronized (object) {
            ifAlarm = AlarmLimiter.ifAlarm(executorWrapper.getThreadPoolName(), notifyItemEnum.getValue());
            if (!ifAlarm) {
                log.warn("DynamicTp notify, concurrent send, alarm limit, dtpName: {}, notifyItem: {}", (Object)executorWrapper.getThreadPoolName(), (Object)notifyItemEnum.getValue());
                return;
            }
            AlarmLimiter.putVal(executorWrapper.getThreadPoolName(), notifyItemEnum.getValue());
        }
        nextFilter.invoke((Object)context);
    }
}

