/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.base;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.dtp.common.dto.MarkdownReq;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyPlatformEnum;
import com.dtp.core.notify.base.Notifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(WechatNotifier.class);

    @Override
    public String platform() {
        return NotifyPlatformEnum.WECHAT.name().toLowerCase();
    }

    @Override
    public void send(NotifyPlatform platform, String text) {
        String serverUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=" + platform.getUrlKey();
        MarkdownReq markdownReq = new MarkdownReq();
        markdownReq.setMsgtype("markdown");
        MarkdownReq.Markdown markdown = new MarkdownReq.Markdown();
        markdown.setContent(text);
        markdownReq.setMarkdown(markdown);
        try {
            HttpResponse response = HttpRequest.post((String)serverUrl).body(JSONUtil.toJsonStr((Object)markdownReq)).execute();
            if (Objects.nonNull(response)) {
                log.info("DynamicTp notify, wechat send success, response: {}, request:{}", (Object)response.body(), (Object)JSONUtil.toJsonStr((Object)markdownReq));
            }
        }
        catch (Exception e) {
            log.error("DynamicTp notify, wechat send failed...", (Throwable)e);
        }
    }
}

