/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.base;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyPlatformEnum;
import com.dtp.core.notify.base.Notifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LarkNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(LarkNotifier.class);

    @Override
    public String platform() {
        return NotifyPlatformEnum.LARK.name().toLowerCase();
    }

    @Override
    public void send(NotifyPlatform notifyPlatform, String text) {
        String serverUrl = "https://open.feishu.cn/open-apis/bot/v2/hook/" + notifyPlatform.getUrlKey();
        try {
            HttpResponse response = HttpRequest.post((String)serverUrl).body(text).execute();
            if (Objects.nonNull(response)) {
                log.info("DynamicTp notify, lark send success, response: {}, request:{}", (Object)response.body(), (Object)text);
            }
        }
        catch (Exception e) {
            log.error("DynamicTp notify, lark send fail...", (Throwable)e);
        }
    }
}

