/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.base;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.dtp.common.dto.MarkdownReq;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyPlatformEnum;
import com.dtp.common.util.DingSignUtil;
import com.dtp.core.notify.base.Notifier;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(DingNotifier.class);

    @Override
    public String platform() {
        return NotifyPlatformEnum.DING.name().toLowerCase();
    }

    @Override
    public void send(NotifyPlatform platform, String text) {
        MarkdownReq.Markdown markdown = new MarkdownReq.Markdown();
        markdown.setTitle("\u52a8\u6001\u7ebf\u7a0b\u6c60\u901a\u77e5");
        markdown.setText(text);
        MarkdownReq.At at = new MarkdownReq.At();
        List mobiles = StrUtil.split((CharSequence)platform.getReceivers(), (char)',');
        at.setAtMobiles(mobiles);
        if (CollUtil.isEmpty((Collection)mobiles)) {
            at.setAtAll(true);
        }
        MarkdownReq markdownReq = new MarkdownReq();
        markdownReq.setMsgtype("markdown");
        markdownReq.setMarkdown(markdown);
        markdownReq.setAt(at);
        String hookUrl = this.getTargetUrl(platform.getSecret(), platform.getUrlKey());
        try {
            HttpResponse response = HttpRequest.post((String)hookUrl).body(JSONUtil.toJsonStr((Object)markdownReq)).execute();
            if (Objects.nonNull(response)) {
                log.info("DynamicTp notify, ding send success, response: {}, request: {}", (Object)response.body(), (Object)JSONUtil.toJsonStr((Object)markdownReq));
            }
        }
        catch (Exception e) {
            log.error("DynamicTp notify, ding send failed...", (Throwable)e);
        }
    }

    private String getTargetUrl(String secret, String accessToken) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return "https://oapi.dingtalk.com/robot/send?access_token=" + accessToken;
        }
        long timestamp = System.currentTimeMillis();
        String sign = DingSignUtil.dingSign((String)secret, (long)timestamp);
        return "https://oapi.dingtalk.com/robot/send?access_token=" + accessToken + "&timestamp=" + timestamp + "&sign=" + sign;
    }
}

