/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.alarm;

import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.core.thread.DtpExecutor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class AlarmCounter {
    private static final String DEFAULT_COUNT_STR = "--- / ---";
    private static final Map<String, AlarmInfo> ALARM_INFO_CACHE = new ConcurrentHashMap<String, AlarmInfo>();

    private AlarmCounter() {
    }

    public static void init(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = AlarmInfo.builder().notifyItem(NotifyItemEnum.of((String)notifyItemType)).build();
        ALARM_INFO_CACHE.putIfAbsent(key, alarmInfo);
    }

    public static AlarmInfo getAlarmInfo(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        return ALARM_INFO_CACHE.get(key);
    }

    public static String getCount(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        if (Objects.nonNull(alarmInfo)) {
            return String.valueOf(alarmInfo.getCount());
        }
        return "---";
    }

    public static void reset(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        alarmInfo.reset();
    }

    public static void incAlarmCounter(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        if (Objects.nonNull(alarmInfo)) {
            alarmInfo.incCounter();
        }
    }

    public static Triple<String, String, String> countStrRrq(String threadPoolName, ThreadPoolExecutor executor) {
        if (!(executor instanceof DtpExecutor)) {
            return new ImmutableTriple((Object)DEFAULT_COUNT_STR, (Object)DEFAULT_COUNT_STR, (Object)DEFAULT_COUNT_STR);
        }
        DtpExecutor dtpExecutor = (DtpExecutor)executor;
        String rejectCount = AlarmCounter.getCount(threadPoolName, NotifyItemEnum.REJECT.getValue()) + " / " + dtpExecutor.getRejectCount();
        String runTimeoutCount = AlarmCounter.getCount(threadPoolName, NotifyItemEnum.RUN_TIMEOUT.getValue()) + " / " + dtpExecutor.getRunTimeoutCount();
        String queueTimeoutCount = AlarmCounter.getCount(threadPoolName, NotifyItemEnum.QUEUE_TIMEOUT.getValue()) + " / " + dtpExecutor.getQueueTimeoutCount();
        return new ImmutableTriple((Object)rejectCount, (Object)runTimeoutCount, (Object)queueTimeoutCount);
    }

    private static String buildKey(String threadPoolName, String notifyItemType) {
        return threadPoolName + ":" + notifyItemType;
    }
}

