/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.common.em.NotifyPlatformEnum;
import com.dtp.common.util.CommonUtil;
import com.dtp.core.context.AlarmCtx;
import com.dtp.core.context.BaseNotifyCtx;
import com.dtp.core.context.DtpNotifyCtxHolder;
import com.dtp.core.notify.DtpNotifier;
import com.dtp.core.notify.alarm.AlarmCounter;
import com.dtp.core.notify.base.Notifier;
import com.dtp.core.notify.manager.NotifyItemManager;
import com.dtp.core.thread.DtpExecutor;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDtpNotifier
implements DtpNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractDtpNotifier.class);
    protected Notifier notifier;

    protected AbstractDtpNotifier() {
    }

    protected AbstractDtpNotifier(Notifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void sendChangeMsg(DtpMainProp oldProp, List<String> diffs) {
        NotifyPlatform platform = DtpNotifyCtxHolder.get().getPlatform(this.platform());
        String content = this.buildNoticeContent(platform, oldProp, diffs);
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        this.notifier.send(platform, content);
    }

    @Override
    public void sendAlarmMsg(NotifyItemEnum notifyItemEnum) {
        NotifyPlatform platform = DtpNotifyCtxHolder.get().getPlatform(this.platform());
        String content = this.buildAlarmContent(platform, notifyItemEnum);
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        this.notifier.send(platform, content);
    }

    protected abstract String getNoticeTemplate();

    protected abstract String getAlarmTemplate();

    protected abstract Pair<String, String> getColors();

    protected String buildAlarmContent(NotifyPlatform platform, NotifyItemEnum notifyItemEnum) {
        AlarmCtx context = (AlarmCtx)DtpNotifyCtxHolder.get();
        String threadPoolName = context.getExecutorWrapper().getThreadPoolName();
        ExecutorWrapper executorWrapper = context.getExecutorWrapper();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)context.getExecutorWrapper().getExecutor();
        NotifyItem notifyItem = context.getNotifyItem();
        AlarmInfo alarmInfo = context.getAlarmInfo();
        Triple<String, String, String> alarmCounter = AlarmCounter.countStrRrq(threadPoolName, executor);
        String receivesStr = this.getReceives(platform.getPlatform(), platform.getReceivers());
        String content = String.format(this.getAlarmTemplate(), CommonUtil.getInstance().getServiceName(), CommonUtil.getInstance().getIp() + ":" + CommonUtil.getInstance().getPort(), CommonUtil.getInstance().getEnv(), this.populatePoolName(executorWrapper), notifyItemEnum.getValue(), notifyItem.getThreshold(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getPoolSize(), executor.getActiveCount(), executor.getLargestPoolSize(), executor.getTaskCount(), executor.getCompletedTaskCount(), executor.getQueue().size(), executor.getQueue().getClass().getSimpleName(), this.getQueueCapacity(executor), executor.getQueue().size(), executor.getQueue().remainingCapacity(), this.getRejectHandlerName(executor), alarmCounter.getLeft(), alarmCounter.getMiddle(), alarmCounter.getRight(), alarmInfo.getLastAlarmTime() == null ? "---" : alarmInfo.getLastAlarmTime(), DateUtil.now(), receivesStr, notifyItem.getInterval());
        return this.highlightAlarmContent(content, notifyItemEnum);
    }

    protected String buildNoticeContent(NotifyPlatform platform, DtpMainProp oldProp, List<String> diffs) {
        BaseNotifyCtx context = DtpNotifyCtxHolder.get();
        ExecutorWrapper executorWrapper = context.getExecutorWrapper();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)executorWrapper.getExecutor();
        String receivesStr = this.getReceives(platform.getPlatform(), platform.getReceivers());
        String content = String.format(this.getNoticeTemplate(), CommonUtil.getInstance().getServiceName(), CommonUtil.getInstance().getIp() + ":" + CommonUtil.getInstance().getPort(), CommonUtil.getInstance().getEnv(), this.populatePoolName(executorWrapper), oldProp.getCorePoolSize(), executor.getCorePoolSize(), oldProp.getMaxPoolSize(), executor.getMaximumPoolSize(), oldProp.isAllowCoreThreadTimeOut(), executor.allowsCoreThreadTimeOut(), oldProp.getKeepAliveTime(), executor.getKeepAliveTime(TimeUnit.SECONDS), executor.getQueue().getClass().getSimpleName(), oldProp.getQueueCapacity(), this.getQueueCapacity(executor), oldProp.getRejectType(), this.getRejectHandlerName(executor), receivesStr, DateTime.now());
        return this.highlightNotifyContent(content, diffs);
    }

    private String getReceives(String platform, String receives) {
        if (StringUtils.isBlank((CharSequence)receives)) {
            return "";
        }
        if (NotifyPlatformEnum.LARK.name().toLowerCase().equals(platform)) {
            return Arrays.stream(receives.split(",")).map(receive -> StringUtils.startsWith((CharSequence)receive, (CharSequence)"ou_") ? String.format("<at id='%s'></at>", receive) : String.format("<at id=''>%s</at>", receive)).collect(Collectors.joining(" "));
        }
        Object[] receivers = StringUtils.split((String)receives, (char)',');
        return Joiner.on((String)", @").join(receivers);
    }

    protected String populatePoolName(ExecutorWrapper executorWrapper) {
        String poolAlisaName = executorWrapper.getExecutor() instanceof DtpExecutor ? ((DtpExecutor)executorWrapper.getExecutor()).getThreadPoolAliasName() : executorWrapper.getThreadPoolAliasName();
        if (StringUtils.isBlank((CharSequence)poolAlisaName)) {
            return executorWrapper.getThreadPoolName();
        }
        return executorWrapper.getThreadPoolName() + "(" + poolAlisaName + ")";
    }

    protected String getRejectHandlerName(ThreadPoolExecutor executor) {
        if (executor instanceof DtpExecutor) {
            return ((DtpExecutor)executor).getRejectHandlerName();
        }
        return executor.getRejectedExecutionHandler().getClass().getSimpleName();
    }

    protected int getQueueCapacity(ThreadPoolExecutor executor) {
        if (executor instanceof DtpExecutor) {
            return ((DtpExecutor)executor).getQueueCapacity();
        }
        return executor.getQueue().size() + executor.getQueue().remainingCapacity();
    }

    private String highlightNotifyContent(String content, List<String> diffs) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Pair<String, String> pair = this.getColors();
        for (String string : diffs) {
            content = content.replace(string, (CharSequence)pair.getLeft());
        }
        for (Field field : DtpMainProp.getMainProps()) {
            content = content.replace(field.getName(), (CharSequence)pair.getRight());
        }
        return content;
    }

    private String highlightAlarmContent(String content, NotifyItemEnum notifyItemEnum) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Set<String> colorKeys = NotifyItemManager.getAlarmKeys(notifyItemEnum);
        Pair<String, String> pair = this.getColors();
        for (String field : colorKeys) {
            content = content.replace(field, (CharSequence)pair.getLeft());
        }
        for (String field : NotifyItemManager.getAllAlarmKeys()) {
            content = content.replace(field, (CharSequence)pair.getRight());
        }
        return content;
    }
}

