/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.monitor.collector;

import cn.hutool.core.bean.BeanUtil;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.em.CollectorTypeEnum;
import com.dtp.common.util.CommonUtil;
import com.dtp.core.monitor.collector.AbstractCollector;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroMeterCollector
extends AbstractCollector {
    private static final Logger log = LoggerFactory.getLogger(MicroMeterCollector.class);
    public static final String DTP_METRIC_NAME_PREFIX = "thread.pool";
    public static final String POOL_NAME_TAG = "thread.pool.name";
    public static final String APP_NAME_TAG = "app.name";
    private static final Map<String, ThreadPoolStats> GAUGE_CACHE = new ConcurrentHashMap<String, ThreadPoolStats>();

    @Override
    public void collect(ThreadPoolStats threadPoolStats) {
        ThreadPoolStats oldStats = GAUGE_CACHE.get(threadPoolStats.getPoolName());
        if (Objects.isNull(oldStats)) {
            GAUGE_CACHE.put(threadPoolStats.getPoolName(), threadPoolStats);
        } else {
            BeanUtil.copyProperties((Object)threadPoolStats, (Object)oldStats, (String[])new String[0]);
        }
        this.gauge(GAUGE_CACHE.get(threadPoolStats.getPoolName()));
    }

    @Override
    public String type() {
        return CollectorTypeEnum.MICROMETER.name().toLowerCase();
    }

    public void gauge(ThreadPoolStats poolStats) {
        ArrayList tags = Lists.newArrayList((Object[])new Tag[]{Tag.of((String)POOL_NAME_TAG, (String)poolStats.getPoolName()), Tag.of((String)APP_NAME_TAG, (String)CommonUtil.getInstance().getServiceName())});
        Metrics.gauge((String)MicroMeterCollector.metricName("core.size"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getCorePoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("maximum.size"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getMaximumPoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("current.size"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getPoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("largest.size"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getLargestPoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("active.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getActiveCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("task.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getTaskCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getCompletedTaskCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("wait.task.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getWaitTaskCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.size"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getQueueSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.capacity"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getQueueCapacity);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.remaining.capacity"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getQueueRemainingCapacity);
        Metrics.gauge((String)MicroMeterCollector.metricName("reject.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getRejectCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("run.timeout.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getRunTimeoutCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.timeout.count"), (Iterable)tags, (Object)poolStats, ThreadPoolStats::getQueueTimeoutCount);
    }

    private static String metricName(String name) {
        return String.join((CharSequence)".", DTP_METRIC_NAME_PREFIX, name);
    }
}

