/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.monitor.collector;

import cn.hutool.json.JSONUtil;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.em.CollectorTypeEnum;
import com.dtp.core.monitor.collector.AbstractCollector;
import com.dtp.logging.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCollector
extends AbstractCollector {
    private static final Logger log = LoggerFactory.getLogger(LogCollector.class);

    @Override
    public void collect(ThreadPoolStats threadPoolStats) {
        String metrics = JSONUtil.toJsonStr((Object)threadPoolStats);
        if (LogHelper.getMonitorLogger() == null) {
            log.error("Cannot find monitor logger...");
            return;
        }
        LogHelper.getMonitorLogger().info("{}", (Object)metrics);
    }

    @Override
    public String type() {
        return CollectorTypeEnum.LOGGING.name().toLowerCase();
    }
}

