/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.handler;

import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.core.context.DtpNotifyCtxHolder;
import com.dtp.core.notify.DtpDingNotifier;
import com.dtp.core.notify.DtpLarkNotifier;
import com.dtp.core.notify.DtpNotifier;
import com.dtp.core.notify.DtpWechatNotifier;
import com.dtp.core.notify.base.DingNotifier;
import com.dtp.core.notify.base.LarkNotifier;
import com.dtp.core.notify.base.WechatNotifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifierHandler {
    private static final Logger log = LoggerFactory.getLogger(NotifierHandler.class);
    private static final Map<String, DtpNotifier> NOTIFIERS = new HashMap<String, DtpNotifier>();

    private NotifierHandler() {
        ServiceLoader<DtpNotifier> loader = ServiceLoader.load(DtpNotifier.class);
        for (DtpNotifier notifier : loader) {
            NOTIFIERS.put(notifier.platform(), notifier);
        }
        DtpDingNotifier dingNotifier = new DtpDingNotifier(new DingNotifier());
        DtpWechatNotifier wechatNotifier = new DtpWechatNotifier(new WechatNotifier());
        DtpLarkNotifier larkNotifier = new DtpLarkNotifier(new LarkNotifier());
        NOTIFIERS.put(dingNotifier.platform(), dingNotifier);
        NOTIFIERS.put(wechatNotifier.platform(), wechatNotifier);
        NOTIFIERS.put(larkNotifier.platform(), larkNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotice(DtpMainProp prop, List<String> diffs) {
        try {
            NotifyItem notifyItem = DtpNotifyCtxHolder.get().getNotifyItem();
            for (String platform : notifyItem.getPlatforms()) {
                DtpNotifier notifier = NOTIFIERS.get(platform.toLowerCase());
                if (notifier == null) continue;
                notifier.sendChangeMsg(prop, diffs);
            }
        }
        finally {
            DtpNotifyCtxHolder.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAlarm(NotifyItemEnum notifyItemEnum) {
        try {
            NotifyItem notifyItem = DtpNotifyCtxHolder.get().getNotifyItem();
            for (String platform : notifyItem.getPlatforms()) {
                DtpNotifier notifier = NOTIFIERS.get(platform.toLowerCase());
                if (notifier == null) continue;
                notifier.sendAlarmMsg(notifyItemEnum);
            }
        }
        finally {
            DtpNotifyCtxHolder.remove();
        }
    }

    public static NotifierHandler getInstance() {
        return NotifierHandlerHolder.INSTANCE;
    }

    private static class NotifierHandlerHolder {
        private static final NotifierHandler INSTANCE = new NotifierHandler();

        private NotifierHandlerHolder() {
        }
    }
}

