/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.context;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyItemEnum;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BaseNotifyCtx {
    private ExecutorWrapper executorWrapper;
    private List<NotifyPlatform> platforms;
    private NotifyItem notifyItem;

    public BaseNotifyCtx() {
    }

    public BaseNotifyCtx(ExecutorWrapper wrapper, NotifyItem notifyItem) {
        this.executorWrapper = wrapper;
        this.notifyItem = notifyItem;
    }

    public NotifyPlatform getPlatform(String platform) {
        if (CollUtil.isEmpty(this.platforms)) {
            return null;
        }
        Map map = this.platforms.stream().collect(Collectors.toMap(x -> x.getPlatform().toLowerCase(), Function.identity(), (v1, v2) -> v2));
        return (NotifyPlatform)map.get(platform.toLowerCase());
    }

    public NotifyItemEnum getNotifyItemEnum() {
        return NotifyItemEnum.of((String)this.notifyItem.getType());
    }

    public ExecutorWrapper getExecutorWrapper() {
        return this.executorWrapper;
    }

    public List<NotifyPlatform> getPlatforms() {
        return this.platforms;
    }

    public NotifyItem getNotifyItem() {
        return this.notifyItem;
    }

    public void setExecutorWrapper(ExecutorWrapper executorWrapper) {
        this.executorWrapper = executorWrapper;
    }

    public void setPlatforms(List<NotifyPlatform> platforms) {
        this.platforms = platforms;
    }

    public void setNotifyItem(NotifyItem notifyItem) {
        this.notifyItem = notifyItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseNotifyCtx)) {
            return false;
        }
        BaseNotifyCtx other = (BaseNotifyCtx)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorWrapper this$executorWrapper = this.getExecutorWrapper();
        ExecutorWrapper other$executorWrapper = other.getExecutorWrapper();
        if (this$executorWrapper == null ? other$executorWrapper != null : !this$executorWrapper.equals(other$executorWrapper)) {
            return false;
        }
        List<NotifyPlatform> this$platforms = this.getPlatforms();
        List<NotifyPlatform> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        NotifyItem this$notifyItem = this.getNotifyItem();
        NotifyItem other$notifyItem = other.getNotifyItem();
        return !(this$notifyItem == null ? other$notifyItem != null : !this$notifyItem.equals(other$notifyItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseNotifyCtx;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorWrapper $executorWrapper = this.getExecutorWrapper();
        result = result * 59 + ($executorWrapper == null ? 43 : $executorWrapper.hashCode());
        List<NotifyPlatform> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        NotifyItem $notifyItem = this.getNotifyItem();
        result = result * 59 + ($notifyItem == null ? 43 : $notifyItem.hashCode());
        return result;
    }

    public String toString() {
        return "BaseNotifyCtx(executorWrapper=" + this.getExecutorWrapper() + ", platforms=" + this.getPlatforms() + ", notifyItem=" + this.getNotifyItem() + ")";
    }
}

