/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.common.constant.DynamicTpConst;
import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyItemEnum;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.ex.DtpException;
import com.dtp.common.queue.MemorySafeLinkedBlockingQueue;
import com.dtp.common.queue.VariableLinkedBlockingQueue;
import com.dtp.core.context.NoticeCtx;
import com.dtp.core.convert.ExecutorConverter;
import com.dtp.core.notify.manager.AlarmManager;
import com.dtp.core.notify.manager.NoticeManager;
import com.dtp.core.notify.manager.NotifyItemManager;
import com.dtp.core.reject.RejectHandlerGetter;
import com.dtp.core.support.ExecutorType;
import com.dtp.core.support.wrapper.TaskWrapper;
import com.dtp.core.support.wrapper.TaskWrappers;
import com.dtp.core.thread.DtpExecutor;
import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import com.github.dadiyang.equator.GetterBaseEquator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.Ordered;

public class DtpRegistry
implements ApplicationRunner,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DtpRegistry.class);
    private static final Map<String, DtpExecutor> DTP_REGISTRY = new ConcurrentHashMap<String, DtpExecutor>();
    private static final Map<String, ExecutorWrapper> COMMON_REGISTRY = new ConcurrentHashMap<String, ExecutorWrapper>();
    private static final Equator EQUATOR = new GetterBaseEquator();
    private static DtpProperties dtpProperties;

    public static List<String> listAllDtpNames() {
        return Lists.newArrayList(DTP_REGISTRY.keySet());
    }

    public static List<String> listAllCommonNames() {
        return Lists.newArrayList(COMMON_REGISTRY.keySet());
    }

    public static void registerDtp(DtpExecutor executor, String source) {
        log.info("DynamicTp register dtpExecutor, source: {}, executor: {}", (Object)source, (Object)ExecutorConverter.convert(executor));
        DTP_REGISTRY.putIfAbsent(executor.getThreadPoolName(), executor);
    }

    public static void registerCommon(ExecutorWrapper wrapper, String source) {
        log.info("DynamicTp register commonExecutor, source: {}, name: {}", (Object)source, (Object)wrapper.getThreadPoolName());
        COMMON_REGISTRY.putIfAbsent(wrapper.getThreadPoolName(), wrapper);
    }

    public static DtpExecutor getDtpExecutor(String name) {
        DtpExecutor executor = DTP_REGISTRY.get(name);
        if (Objects.isNull(executor)) {
            log.error("Cannot find a specified dtpExecutor, name: {}", (Object)name);
            throw new DtpException("Cannot find a specified dtpExecutor, name: " + name);
        }
        return executor;
    }

    public static ExecutorWrapper getCommonExecutor(String name) {
        ExecutorWrapper executor = COMMON_REGISTRY.get(name);
        if (Objects.isNull(executor)) {
            log.error("Cannot find a specified commonExecutor, name: {}", (Object)name);
            throw new DtpException("Cannot find a specified commonExecutor, name: " + name);
        }
        return executor;
    }

    public static void refresh(DtpProperties properties) {
        if (Objects.isNull(properties) || CollUtil.isEmpty((Collection)properties.getExecutors())) {
            log.warn("DynamicTp refresh, empty threadPoolProperties.");
            return;
        }
        properties.getExecutors().forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getThreadPoolName())) {
                log.warn("DynamicTp refresh, threadPoolName must not be empty.");
                return;
            }
            DtpExecutor dtpExecutor = DTP_REGISTRY.get(x.getThreadPoolName());
            if (Objects.isNull(dtpExecutor)) {
                log.warn("DynamicTp refresh, cannot find specified dtpExecutor, name: {}.", (Object)x.getThreadPoolName());
                return;
            }
            DtpRegistry.refresh(dtpExecutor, x);
        });
    }

    private static void refresh(DtpExecutor executor, ThreadPoolProperties properties) {
        boolean ifNotice;
        if (properties.getCorePoolSize() < 0 || properties.getMaximumPoolSize() <= 0 || properties.getMaximumPoolSize() < properties.getCorePoolSize() || properties.getKeepAliveTime() < 0L) {
            log.error("DynamicTp refresh, invalid parameters exist, properties: {}", (Object)properties);
            return;
        }
        if (executor.getMaximumPoolSize() < properties.getCorePoolSize()) {
            log.error("DynamicTp refresh, new corePoolSize [{}] cannot greater than current maximumPoolSize [{}].", (Object)properties.getCorePoolSize(), (Object)executor.getMaximumPoolSize());
            return;
        }
        DtpMainProp oldProp = ExecutorConverter.convert(executor);
        DtpRegistry.doRefresh(executor, properties);
        DtpMainProp newProp = ExecutorConverter.convert(executor);
        if (oldProp.equals((Object)newProp)) {
            log.warn("DynamicTp refresh, main properties of [{}] have not changed.", (Object)executor.getThreadPoolName());
            return;
        }
        List diffFields = EQUATOR.getDiffFields((Object)oldProp, (Object)newProp);
        List<String> diffKeys = diffFields.stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        log.info("DynamicTp refresh, name: [{}], changed keys: {}, corePoolSize: [{}], maxPoolSize: [{}], queueType: [{}], queueCapacity: [{}], keepAliveTime: [{}], rejectedType: [{}], allowsCoreThreadTimeOut: [{}]", new Object[]{executor.getThreadPoolName(), diffKeys, String.format("%s => %s", oldProp.getCorePoolSize(), newProp.getCorePoolSize()), String.format("%s => %s", oldProp.getMaxPoolSize(), newProp.getMaxPoolSize()), String.format("%s => %s", oldProp.getQueueType(), newProp.getQueueType()), String.format("%s => %s", oldProp.getQueueCapacity(), newProp.getQueueCapacity()), String.format("%ss => %ss", oldProp.getKeepAliveTime(), newProp.getKeepAliveTime()), String.format("%s => %s", oldProp.getRejectType(), newProp.getRejectType()), String.format("%s => %s", oldProp.isAllowCoreThreadTimeOut(), newProp.isAllowCoreThreadTimeOut())});
        List platforms = dtpProperties.getPlatforms();
        NotifyItem notifyItem = NotifyItemManager.getNotifyItem(executor, NotifyItemEnum.CHANGE);
        boolean bl = ifNotice = CollUtil.isNotEmpty((Collection)platforms) && Objects.nonNull(notifyItem) && notifyItem.isEnabled();
        if (!ifNotice) {
            log.debug("DynamicTp refresh, change notification is not enabled, poolName: {}", (Object)executor.getThreadPoolName());
            return;
        }
        ExecutorWrapper executorWrapper = new ExecutorWrapper(executor.getThreadPoolName(), (Executor)executor);
        NoticeCtx context = new NoticeCtx(executorWrapper, notifyItem, platforms, oldProp, diffKeys);
        NoticeManager.doNoticeAsync(context);
    }

    private static void doRefresh(DtpExecutor dtpExecutor, ThreadPoolProperties properties) {
        if (!Objects.equals(dtpExecutor.getCorePoolSize(), properties.getCorePoolSize())) {
            dtpExecutor.setCorePoolSize(properties.getCorePoolSize());
        }
        if (!Objects.equals(dtpExecutor.getMaximumPoolSize(), properties.getMaximumPoolSize())) {
            dtpExecutor.setMaximumPoolSize(properties.getMaximumPoolSize());
        }
        if (!Objects.equals(dtpExecutor.getKeepAliveTime(properties.getUnit()), properties.getKeepAliveTime())) {
            dtpExecutor.setKeepAliveTime(properties.getKeepAliveTime(), properties.getUnit());
        }
        if (!Objects.equals(dtpExecutor.allowsCoreThreadTimeOut(), properties.isAllowCoreThreadTimeOut())) {
            dtpExecutor.allowCoreThreadTimeOut(properties.isAllowCoreThreadTimeOut());
        }
        if (!Objects.equals(dtpExecutor.getRejectHandlerName(), properties.getRejectedHandlerType())) {
            dtpExecutor.setRejectedExecutionHandler(RejectHandlerGetter.getProxy(properties.getRejectedHandlerType()));
            dtpExecutor.setRejectHandlerName(properties.getRejectedHandlerType());
        }
        if (!Objects.equals(dtpExecutor.getThreadPoolAliasName(), properties.getThreadPoolAliasName())) {
            dtpExecutor.setThreadPoolAliasName(properties.getThreadPoolAliasName());
        }
        if (DtpRegistry.canModifyQueueProp(properties)) {
            BlockingQueue<Runnable> blockingQueue = dtpExecutor.getQueue();
            if (!Objects.equals(dtpExecutor.getQueueCapacity(), properties.getQueueCapacity())) {
                if (blockingQueue instanceof VariableLinkedBlockingQueue) {
                    ((VariableLinkedBlockingQueue)blockingQueue).setCapacity(properties.getQueueCapacity());
                } else {
                    log.error("DynamicTp refresh, the blockingqueue capacity cannot be reset, dtpName: {}, queueType {}", (Object)dtpExecutor.getThreadPoolName(), (Object)dtpExecutor.getQueueName());
                }
            }
            if (blockingQueue instanceof MemorySafeLinkedBlockingQueue) {
                ((MemorySafeLinkedBlockingQueue)blockingQueue).setMaxFreeMemory(properties.getMaxFreeMemory() * DynamicTpConst.M_1);
            }
        }
        dtpExecutor.setWaitForTasksToCompleteOnShutdown(properties.isWaitForTasksToCompleteOnShutdown());
        dtpExecutor.setAwaitTerminationSeconds(properties.getAwaitTerminationSeconds());
        dtpExecutor.setPreStartAllCoreThreads(properties.isPreStartAllCoreThreads());
        dtpExecutor.setRunTimeout(properties.getRunTimeout());
        dtpExecutor.setQueueTimeout(properties.getQueueTimeout());
        List<TaskWrapper> taskWrappers = TaskWrappers.getInstance().getByNames(properties.getTaskWrapperNames());
        dtpExecutor.setTaskWrappers(taskWrappers);
        List allNotifyItems = NotifyItem.mergeAllNotifyItems((List)properties.getNotifyItems());
        AlarmManager.refreshAlarm(dtpExecutor.getThreadPoolName(), dtpProperties.getPlatforms(), dtpExecutor.getNotifyItems(), allNotifyItems);
        dtpExecutor.setNotifyItems(allNotifyItems);
    }

    @Autowired
    public void setDtpProperties(DtpProperties dtpProperties) {
        DtpRegistry.dtpProperties = dtpProperties;
    }

    public void run(ApplicationArguments args) {
        Set remoteExecutors = Collections.emptySet();
        if (CollUtil.isNotEmpty((Collection)dtpProperties.getExecutors())) {
            remoteExecutors = dtpProperties.getExecutors().stream().map(ThreadPoolProperties::getThreadPoolName).collect(Collectors.toSet());
        }
        HashSet registeredDtpExecutors = Sets.newHashSet(DTP_REGISTRY.keySet());
        Collection localDtpExecutors = CollUtil.subtract((Collection)registeredDtpExecutors, remoteExecutors);
        Set<String> localCommonExecutors = COMMON_REGISTRY.keySet();
        log.info("DtpRegistry initialization end, remote dtpExecutors: {}, local dtpExecutors: {}, local commonExecutors: {}", new Object[]{remoteExecutors, localDtpExecutors, localCommonExecutors});
        if (CollUtil.isEmpty((Collection)dtpProperties.getPlatforms())) {
            log.warn("DtpRegistry initialization end, no notify platforms configured.");
        }
    }

    private static boolean canModifyQueueProp(ThreadPoolProperties properties) {
        return Objects.equals(properties.getQueueType(), QueueTypeEnum.VARIABLE_LINKED_BLOCKING_QUEUE.getName()) || Objects.equals(properties.getQueueType(), QueueTypeEnum.MEMORY_SAFE_LINKED_BLOCKING_QUEUE.getName()) || Objects.equals(properties.getExecutorType(), ExecutorType.EAGER.getName());
    }

    public int getOrder() {
        return -2147483647;
    }
}

