/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.util;

import com.dtp.common.config.DtpProperties;
import com.dtp.common.em.ConfigFileTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public final class NacosUtil {
    private NacosUtil() {
    }

    public static String deduceDataId(DtpProperties.Nacos nacos, Environment environment, ConfigFileTypeEnum configFileType) {
        String dataId;
        if (nacos != null && StringUtils.isNotBlank((CharSequence)nacos.getDataId())) {
            dataId = nacos.getDataId();
        } else {
            String[] profiles = environment.getActiveProfiles();
            if (profiles.length < 1) {
                profiles = environment.getDefaultProfiles();
            }
            String appName = environment.getProperty("spring.application.name");
            appName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appName}) ? appName : "application";
            dataId = appName + "-" + profiles[0] + "." + configFileType.getValue();
        }
        return dataId;
    }

    public static String getGroup(DtpProperties.Nacos nacos, String defaultGroup) {
        String group = defaultGroup;
        if (nacos != null && StringUtils.isNotBlank((CharSequence)nacos.getGroup())) {
            group = nacos.getGroup();
        }
        return group;
    }

    public static ConfigFileTypeEnum getConfigType(DtpProperties dtpProperties, ConfigFileTypeEnum defaultType) {
        ConfigFileTypeEnum configFileType = defaultType;
        if (StringUtils.isNotBlank((CharSequence)dtpProperties.getConfigType())) {
            configFileType = ConfigFileTypeEnum.of(dtpProperties.getConfigType());
        }
        return configFileType;
    }
}

