/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.util;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DingSignUtil {
    private static final Logger log = LoggerFactory.getLogger(DingSignUtil.class);
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String ALGORITHM = "HmacSHA256";

    private DingSignUtil() {
    }

    public static String dingSign(String secret, long timestamp) {
        String stringToSign = timestamp + "\n" + secret;
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(secret.getBytes(DEFAULT_ENCODING), ALGORITHM));
            byte[] signData = mac.doFinal(stringToSign.getBytes(DEFAULT_ENCODING));
            return URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), DEFAULT_ENCODING.name());
        }
        catch (Exception e) {
            log.error("DynamicTp, cal ding sign error", (Throwable)e);
            return "";
        }
    }
}

