/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.util;

import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.dto.Instance;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public final class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final Instance INSTANCE;

    private CommonUtil() {
    }

    public static Instance getInstance() {
        return INSTANCE;
    }

    static {
        Environment environment = ApplicationContextHolder.getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        appName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appName}) ? appName : "application";
        String portStr = environment.getProperty("server.port");
        int port = StringUtils.isNotBlank((CharSequence)portStr) ? Integer.parseInt(portStr) : 0;
        String address = null;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("get localhost address error.", (Throwable)e);
        }
        String[] profiles = environment.getActiveProfiles();
        if (profiles.length < 1) {
            profiles = environment.getDefaultProfiles();
        }
        INSTANCE = new Instance(address, port, appName, profiles[0]);
    }
}

