/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.queue;

import com.dtp.common.queue.MemoryLimitCalculator;
import com.dtp.common.queue.VariableLinkedBlockingQueue;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class MemorySafeLinkedBlockingQueue<E>
extends VariableLinkedBlockingQueue<E> {
    private static final long serialVersionUID = 8032578371739960142L;
    public static final int THE_256_MB = 0x10000000;
    private int maxFreeMemory;

    public MemorySafeLinkedBlockingQueue() {
        this(0x10000000);
    }

    public MemorySafeLinkedBlockingQueue(int maxFreeMemory) {
        super(Integer.MAX_VALUE);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLinkedBlockingQueue(int capacity, int maxFreeMemory) {
        super(capacity);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLinkedBlockingQueue(Collection<? extends E> c, int maxFreeMemory) {
        super(c);
        this.maxFreeMemory = maxFreeMemory;
    }

    public void setMaxFreeMemory(int maxFreeMemory) {
        this.maxFreeMemory = maxFreeMemory;
    }

    public int getMaxFreeMemory() {
        return this.maxFreeMemory;
    }

    public boolean hasRemainedMemory() {
        if (MemoryLimitCalculator.maxAvailable() > (long)this.maxFreeMemory) {
            return true;
        }
        throw new RejectedExecutionException("No more memory can be used.");
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (this.hasRemainedMemory()) {
            super.put(e);
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.hasRemainedMemory() && super.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        return this.hasRemainedMemory() && super.offer(e);
    }
}

