/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.pattern.filter;

import com.dtp.common.pattern.filter.Filter;
import com.dtp.common.pattern.filter.FilterChain;
import com.dtp.common.pattern.filter.Invoker;

public final class FilterChainFactory {
    private FilterChainFactory() {
    }

    @SafeVarargs
    public static <T> FilterChain<T> buildFilterChain(Invoker<T> target, Filter<T> ... filters) {
        FilterChain filterChain = new FilterChain();
        Invoker last = target;
        for (int i = filters.length - 1; i >= 0; --i) {
            final Invoker next = last;
            final Filter<T> filter = filters[i];
            last = new Invoker<T>(){

                @Override
                public void invoke(T context) {
                    filter.doFilter(context, next);
                }
            };
        }
        filterChain.setHead(last);
        return filterChain;
    }
}

