/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.temp.jwt;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.temp.SaTempTemplate;
import cn.dev33.satoken.temp.jwt.SaJwtUtil;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.List;

public class SaTempTemplateForJwt
extends SaTempTemplate {
    public String createToken(Object value, long timeout, boolean isRecordIndex) {
        return SaJwtUtil.createToken(value, timeout, this.getJwtSecretKey());
    }

    public Object parseToken(String token) {
        return SaJwtUtil.getValue(token, this.getJwtSecretKey());
    }

    public long getTimeout(String token) {
        return SaJwtUtil.getTimeout(token, this.getJwtSecretKey());
    }

    public void deleteToken(String token) {
        throw new ApiDisabledException("jwt cannot delete token").setCode(30302);
    }

    public List<String> getTempTokenList(Object value) {
        throw new ApiDisabledException("jwt cannot get token list").setCode(30304);
    }

    public String getJwtSecretKey() {
        String jwtSecretKey = SaManager.getConfig().getJwtSecretKey();
        if (SaFoxUtil.isEmpty((Object)jwtSecretKey)) {
            throw new SaTokenException("\u8bf7\u914d\u7f6e\uff1ajwtSecretKey").setCode(30301);
        }
        return jwtSecretKey;
    }
}

