/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.temp.jwt;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.secure.SaSecureUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import javax.crypto.SecretKey;

public class SaJwtUtil {
    public static final String KEY_VALUE = "value_";
    public static final String KEY_EFF = "eff";
    public static final long NEVER_EXPIRE = -1L;

    public static String createToken(Object value, long timeout, String keyt) {
        long eff = timeout;
        if (timeout != -1L) {
            eff = timeout * 1000L + System.currentTimeMillis();
        }
        SecretKey key = Keys.hmacShaKeyFor((byte[])SaSecureUtil.md5((String)keyt).getBytes());
        JwtBuilder builder = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().add((Object)"typ", (Object)"JWT")).and()).claim(KEY_VALUE, value).claim(KEY_EFF, (Object)eff).signWith((Key)key);
        return builder.compact();
    }

    public static Claims parseToken(String jwtToken, String keyt) {
        SecretKey key = Keys.hmacShaKeyFor((byte[])SaSecureUtil.md5((String)keyt).getBytes());
        return (Claims)Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)jwtToken).getPayload();
    }

    public static Object getValue(String jwtToken, String keyt) {
        Claims claims = SaJwtUtil.parseToken(jwtToken, keyt);
        Long eff = (Long)claims.get(KEY_EFF, Long.class);
        if (eff == null || eff < System.currentTimeMillis() && eff != -1L) {
            throw new SaTokenException("token \u5df2\u8d85\u65f6\uff0c\u65e0\u6cd5\u89e3\u6790\uff1a" + jwtToken).setCode(30303);
        }
        return claims.get((Object)KEY_VALUE);
    }

    public static long getTimeout(String jwtToken, String keyt) {
        Claims claims = SaJwtUtil.parseToken(jwtToken, keyt);
        Long eff = (Long)claims.get(KEY_EFF, Long.class);
        if (eff == -1L) {
            return -1L;
        }
        if (eff < System.currentTimeMillis()) {
            return -2L;
        }
        return (eff - System.currentTimeMillis()) / 1000L;
    }
}

