/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.filter;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.exception.FirewallCheckException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.servlet.model.SaRequestForServlet;
import cn.dev33.satoken.servlet.model.SaResponseForServlet;
import cn.dev33.satoken.strategy.SaFirewallStrategy;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.annotation.Order;

@Order(value=-1000)
public class SaFirewallCheckFilterForJakartaServlet
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        SaRequestForServlet saRequest = new SaRequestForServlet(req);
        SaResponseForServlet saResponse = new SaResponseForServlet(res);
        try {
            SaFirewallStrategy.instance.check.execute((SaRequest)saRequest, (SaResponse)saResponse, null);
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (FirewallCheckException e) {
            if (SaFirewallStrategy.instance.checkFailHandle == null) {
                response.setContentType("text/plain; charset=utf-8");
                response.getWriter().print(e.getMessage());
                response.getWriter().flush();
            } else {
                SaFirewallStrategy.instance.checkFailHandle.run(e, (SaRequest)saRequest, (SaResponse)saResponse, null);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

