/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.interceptor;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.autowired.SaTokenSpringAutowired;
import cn.dev33.satoken.fun.IsRunFunction;
import cn.dev33.satoken.fun.SaFunction;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class SaRouterUtil {
    private static PathMatcher pathMatcher;

    public static PathMatcher getPathMatcher() {
        if (pathMatcher == null && (pathMatcher = SaTokenSpringAutowired.pathMatcher) == null) {
            pathMatcher = new AntPathMatcher();
        }
        return pathMatcher;
    }

    public static void setPathMatcher(PathMatcher pathMatcher) {
        SaRouterUtil.pathMatcher = pathMatcher;
    }

    public static boolean isMatch(String pattern, String path) {
        return SaRouterUtil.getPathMatcher().match(pattern, path);
    }

    public static boolean isMatch(List<String> patterns, String path) {
        for (String pattern : patterns) {
            if (!SaRouterUtil.isMatch(pattern, path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchCurrURI(String pattern) {
        return SaRouterUtil.isMatch(pattern, SaTokenManager.getSaTokenServlet().getRequest().getRequestURI());
    }

    public static boolean isMatchCurrURI(List<String> patterns) {
        return SaRouterUtil.isMatch(patterns, SaTokenManager.getSaTokenServlet().getRequest().getRequestURI());
    }

    public static void match(String pattern, SaFunction function) {
        if (SaRouterUtil.isMatchCurrURI(pattern)) {
            function.run();
        }
    }

    public static void match(String pattern, String excludePattern, SaFunction function) {
        if (SaRouterUtil.isMatchCurrURI(pattern) && !SaRouterUtil.isMatchCurrURI(excludePattern)) {
            function.run();
        }
    }

    public static void match(List<String> patterns, SaFunction function) {
        if (SaRouterUtil.isMatchCurrURI(patterns)) {
            function.run();
        }
    }

    public static void match(List<String> patterns, List<String> excludePatterns, SaFunction function) {
        if (SaRouterUtil.isMatchCurrURI(patterns) && !SaRouterUtil.isMatchCurrURI(excludePatterns)) {
            function.run();
        }
    }

    public static IsRunFunction match(String ... patterns) {
        boolean matchResult = SaRouterUtil.isMatch(Arrays.asList(patterns), SaTokenManager.getSaTokenServlet().getRequest().getRequestURI());
        return new IsRunFunction(matchResult);
    }
}

