/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.interceptor;

import cn.dev33.satoken.annotation.SaMode;
import cn.dev33.satoken.interceptor.SaRouteFunction;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;

public class SaRouteInterceptor
implements HandlerInterceptor {
    private StpLogic stpLogic;
    private int type;
    private SaMode mode;
    private String[] codes;
    private SaRouteFunction function;
    public static final int LOGIN = 1;
    public static final int ROLE = 2;
    public static final int PERMISSION = 3;
    public static final int CUSTOM = 4;

    public StpLogic getStpLogic() {
        if (this.stpLogic == null) {
            this.stpLogic = StpUtil.stpLogic;
        }
        return this.stpLogic;
    }

    public SaRouteInterceptor setStpLogic(StpLogic stpLogic) {
        this.stpLogic = stpLogic;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public SaRouteInterceptor setType(int type) {
        this.type = type;
        return this;
    }

    public SaMode getMode() {
        return this.mode;
    }

    public SaRouteInterceptor setMode(SaMode mode) {
        this.mode = mode;
        return this;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public SaRouteInterceptor setCodes(String ... codes) {
        this.codes = codes;
        return this;
    }

    public SaRouteFunction getFunction() {
        return this.function;
    }

    public SaRouteInterceptor setFunction(SaRouteFunction function) {
        this.type = 4;
        this.function = function;
        return this;
    }

    public SaRouteInterceptor(int type, SaMode mode, String ... codes) {
        this.type = type;
        this.mode = mode;
        this.codes = codes;
    }

    public SaRouteInterceptor() {
        this(1, null, new String[0]);
    }

    public SaRouteInterceptor(SaRouteFunction function) {
        this(4, null, new String[0]);
        this.setFunction(function);
    }

    public static SaRouteInterceptor createLoginVal() {
        return new SaRouteInterceptor();
    }

    public static SaRouteInterceptor createRoleVal(String ... roles) {
        return new SaRouteInterceptor(2, SaMode.AND, roles);
    }

    public static SaRouteInterceptor createPermissionVal(String ... permissions) {
        return new SaRouteInterceptor(3, SaMode.AND, permissions);
    }

    public static SaRouteInterceptor createCustomVal(SaRouteFunction function) {
        return new SaRouteInterceptor(function);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.type == 1) {
            this.getStpLogic().checkLogin();
        } else if (this.type == 2) {
            if (this.mode == SaMode.AND) {
                this.getStpLogic().checkRoleAnd(this.codes);
            } else {
                this.getStpLogic().checkRoleOr(this.codes);
            }
        } else if (this.type == 3) {
            if (this.mode == SaMode.AND) {
                this.getStpLogic().checkPermissionAnd(this.codes);
            } else {
                this.getStpLogic().checkPermissionOr(this.codes);
            }
        } else if (this.type == 4) {
            this.function.run(request, response, handler);
        }
        return true;
    }
}

